/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.mixin.accessor.EnchantmentAccessor;
import fuzs.universalenchants.world.item.enchantment.data.AdditionalEnchantmentDataProvider;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;

public class BuiltInEnchantmentDataManager {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final Set<EnchantmentCategory> SPECIALIZED_ARMOR_CATEGORIES = ImmutableSet.of((Object)EnchantmentCategory.ARMOR_FEET, (Object)EnchantmentCategory.ARMOR_LEGS, (Object)EnchantmentCategory.ARMOR_CHEST, (Object)EnchantmentCategory.ARMOR_HEAD);
    public static final BuiltInEnchantmentDataManager INSTANCE = new BuiltInEnchantmentDataManager();
    private final BiMap<Enchantment, EnchantmentCategory> customEnchantmentCategories = HashBiMap.create();
    private final Map<Enchantment, EnchantmentCategory> defaultEnchantmentCategories = Maps.newIdentityHashMap();
    private BiMap<EnchantmentCategory, ResourceLocation> enchantmentCategoriesIdMap;
    private int lastEnchantmentCategoriesSize;

    private BuiltInEnchantmentDataManager() {
    }

    public EnchantmentCategory getVanillaCategory(Enchantment enchantment) {
        EnchantmentCategory category = enchantment.f_44672_;
        if (this.testVanillaCategory(category)) {
            return category;
        }
        category = this.defaultEnchantmentCategories.get(enchantment);
        Objects.requireNonNull(category, "vanilla category for enchantment %s is missing".formatted(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment)));
        return category;
    }

    public void setEnchantmentCategory(Enchantment enchantment, EnchantmentCategory category) {
        EnchantmentCategory currentCategory = enchantment.f_44672_;
        if (this.testVanillaCategory(currentCategory)) {
            this.defaultEnchantmentCategories.put(enchantment, currentCategory);
        }
        ((EnchantmentAccessor)enchantment).universalenchants$setCategory(category);
        if (!this.testVanillaCategory(category)) {
            this.tryUnlockEnchantmentSlots(enchantment);
        }
    }

    private void tryUnlockEnchantmentSlots(Enchantment enchantment) {
        EnchantmentCategory vanillaCategory = this.defaultEnchantmentCategories.get(enchantment);
        if (SPECIALIZED_ARMOR_CATEGORIES.contains(vanillaCategory)) {
            ((EnchantmentAccessor)enchantment).universalenchants$setSlots((EquipmentSlot[])ARMOR_SLOTS.clone());
        }
        if (enchantment == Enchantments.f_44972_) {
            ((EnchantmentAccessor)enchantment).universalenchants$setSlots((EquipmentSlot[])EquipmentSlot.values().clone());
        }
    }

    public EnchantmentCategory getOrBuildCustomCategory(Enchantment enchantment, Predicate<Item> canApplyTo) {
        return (EnchantmentCategory)this.customEnchantmentCategories.computeIfAbsent((Object)enchantment, enchantment1 -> CommonAbstractions.INSTANCE.createEnchantmentCategory(BuiltInEnchantmentDataManager.createCategoryName(enchantment1), canApplyTo));
    }

    private static String createCategoryName(Enchantment enchantment) {
        ResourceLocation id = BuiltInRegistries.f_256876_.m_7981_((Object)enchantment);
        return AdditionalEnchantmentDataProvider.ENCHANTMENT_CATEGORY_PREFIX + "%s_%s".formatted(id.m_135827_(), id.m_135815_()).toUpperCase(Locale.ROOT);
    }

    public boolean testVanillaCategory(EnchantmentCategory category) {
        return !this.customEnchantmentCategories.containsValue((Object)category);
    }

    public EnchantmentCategory convertToVanillaCategory(EnchantmentCategory customCategory) {
        EnchantmentCategory vanillaCategory;
        Enchantment enchantment = (Enchantment)this.customEnchantmentCategories.inverse().get((Object)customCategory);
        if (enchantment != null && (vanillaCategory = this.defaultEnchantmentCategories.get(enchantment)) != null) {
            return vanillaCategory;
        }
        return customCategory;
    }

    public BiMap<EnchantmentCategory, ResourceLocation> getEnchantmentCategoriesIdMap() {
        this.tryRebuildCategoriesIdMap();
        return this.enchantmentCategoriesIdMap;
    }

    private void tryRebuildCategoriesIdMap() {
        AdditionalEnchantmentDataProvider.INSTANCE.initialize();
        EnchantmentCategory[] values = EnchantmentCategory.values();
        if (this.enchantmentCategoriesIdMap == null || this.lastEnchantmentCategoriesSize != values.length) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (EnchantmentCategory category : values) {
                if (!this.testVanillaCategory(category)) continue;
                String identifier = category.name().replaceAll("\\W", "_").toLowerCase(Locale.ROOT);
                builder.put((Object)category, (Object)new ResourceLocation(identifier));
            }
            this.enchantmentCategoriesIdMap = builder.build();
            this.lastEnchantmentCategoriesSize = values.length;
        }
    }
}

