/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.charm.HeliumFlamingoItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class FlamingoSwimPacket {
    private final boolean toggled;

    public static void encode(FlamingoSwimPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.toggled);
    }

    public static FlamingoSwimPacket decode(FriendlyByteBuf buf) {
        return new FlamingoSwimPacket(buf.readBoolean());
    }

    public static void handle(FlamingoSwimPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.get()));
            Item patt1248$temp = stack.m_41720_();
            if (!(patt1248$temp instanceof HeliumFlamingoItem)) {
                return;
            }
            HeliumFlamingoItem relic = (HeliumFlamingoItem)patt1248$temp;
            if (packet.toggled) {
                player.m_6858_(true);
                relic.setToggled(stack, true);
            } else {
                player.m_6858_(false);
                relic.setTime(stack, (int)relic.getAbilityValue(stack, "flying", "time") + 10);
                relic.setToggled(stack, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlamingoSwimPacket)) {
            return false;
        }
        FlamingoSwimPacket other = (FlamingoSwimPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isToggled() == other.isToggled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlamingoSwimPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isToggled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "FlamingoSwimPacket(toggled=" + this.isToggled() + ")";
    }

    public FlamingoSwimPacket(boolean toggled) {
        this.toggled = toggled;
    }
}

