/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class GoldenHookItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"hook").stat(StatData.builder((String)"amount").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-201383).borderBottom(-1659115).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.BASTION).build()).build();
    }

    private static List<ItemStack> findEquippedCurios(Entity entity, Item item) {
        if (!(entity instanceof Player)) {
            return List.of();
        }
        Player player = (Player)entity;
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.findCurios(item).stream().map(SlotResult::stack).toList()).orElse(List.of());
    }

    @Mod.EventBusSubscriber
    public static class GoldenHookEvent {
        @SubscribeEvent
        public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
            Player player = event.getAttackingPlayer();
            List<ItemStack> stacks = GoldenHookItem.findEquippedCurios((Entity)player, (Item)ModItems.GOLDEN_HOOK.get());
            if (stacks.isEmpty()) {
                return;
            }
            double percentage = stacks.stream().mapToDouble(stack -> {
                GoldenHookItem relic;
                Item patt3974$temp = stack.m_41720_();
                if (!(patt3974$temp instanceof GoldenHookItem) || !(relic = (GoldenHookItem)patt3974$temp).canUseAbility((ItemStack)stack, "hook")) {
                    return 0.0;
                }
                relic.spreadExperience((LivingEntity)player, (ItemStack)stack, 1);
                return relic.getAbilityValue((ItemStack)stack, "hook", "amount");
            }).sum();
            int droppedExp = event.getDroppedExperience();
            event.setDroppedExperience((int)((double)droppedExp + (double)droppedExp * percentage));
        }
    }
}

