/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.utils.MathBaseUtils;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class FireGauntletItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"caster").stat(StatData.builder((String)"chance").initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"damage").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.235).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"duration").initialValue(30.0, 50.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-213999).borderBottom(-3068416).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).build()).loot(LootData.builder().entry(LootCollections.NETHER).build()).build();
    }

    @Mod.EventBusSubscriber
    public static class FireGauntletEvent {
        @SubscribeEvent
        public static void onAttack(AttackEntityEvent event) {
            FireGauntletItem relic;
            Player player = event.getEntity();
            Level level = player.m_20193_();
            if (level.m_5776_() || !(event.getTarget() instanceof LivingEntity)) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.FIRE_GAUNTLET.get()));
            Item item = stack.m_41720_();
            if (!(item instanceof FireGauntletItem) || !(relic = (FireGauntletItem)item).canPlayerUseActiveAbility(player, stack, "caster")) {
                return;
            }
            List targets = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_()), entity -> player.m_142582_((Entity)entity) && !entity.m_20148_().equals(player.m_20148_()) && !entity.m_20145_());
            targets.sort(Comparator.comparingDouble(targetEntity -> targetEntity.m_20270_((Entity)player)));
            int targetIndex = 0;
            RandomSource random = player.m_217043_();
            int sparksCount = Math.min(MathBaseUtils.multicast(random, relic.getAbilityValue(stack, "caster", "chance")), targets.size());
            float sparkDamage = (float)(player.m_21204_().m_22181_(Attributes.f_22281_) * (1.0 + relic.getAbilityValue(stack, "caster", "damage")));
            boolean experienceAwarded = false;
            for (int i = 0; i < sparksCount; ++i) {
                LivingEntity target = (LivingEntity)targets.get(targetIndex);
                FireGauntletEvent.createFireSparkEffect((ServerLevel)level, player, target);
                target.f_19802_ = 0;
                if (target.m_6469_(level.m_269111_().m_269075_(player), sparkDamage)) {
                    int fireTicks = (int)relic.getAbilityValue(stack, "caster", "duration") + 20;
                    target.m_7311_(fireTicks);
                    if (!experienceAwarded) {
                        relic.spreadExperience((LivingEntity)player, stack, 1);
                        experienceAwarded = true;
                    }
                }
                targetIndex = (targetIndex + 1) % targets.size();
            }
        }

        private static void createFireSparkEffect(ServerLevel level, Player player, LivingEntity target) {
            int i;
            RandomSource random = level.m_213780_();
            double angle = random.m_188500_() * 2.0 * Math.PI;
            Vec3 startPos = player.m_20182_().m_82520_(Math.cos(angle), 1.0, Math.sin(angle));
            Vec3 targetPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            double distance = startPos.m_82554_(targetPos);
            int particleCount = Math.max(8, (int)Math.ceil(distance * 2.0));
            for (i = 0; i <= particleCount; ++i) {
                double progress = (double)i / (double)particleCount;
                Vec3 particlePos = startPos.m_165921_(targetPos, progress);
                particlePos = particlePos.m_82520_((random.m_188500_() - 0.5) * 0.2, (random.m_188500_() - 0.5) * 0.2, (random.m_188500_() - 0.5) * 0.2);
                level.m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.m_188503_(55), 100 + random.m_188503_(100), random.m_188503_(50)), (float)((float)((double)0.6f + progress * (double)0.4f)), (int)((int)(progress * 20.0) + random.m_188503_(3)), (float)0.85f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.05, 0.05, 0.05, 0.02);
            }
            for (i = 0; i < 12; ++i) {
                Vec3 offset = new Vec3((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5);
                level.m_8767_(ParticleUtils.constructSimpleSpark((Color)new Color(255, 150 + random.m_188503_(100), random.m_188503_(100)), (float)1.0f, (int)(5 + random.m_188503_(3)), (float)0.9f), targetPos.f_82479_ + offset.f_82479_, targetPos.f_82480_ + offset.f_82480_, targetPos.f_82481_ + offset.f_82481_, 1, 0.02, 0.02, 0.02, 0.08);
            }
        }
    }
}

