/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.mobtimizations.loader.forge;

import com.corosus.coroutil.util.CU;
import com.corosus.mobtimizations.CommandMisc;
import com.corosus.mobtimizations.Mobtimizations;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mobtimizations")
public class MobtimizationsForge
extends Mobtimizations {
    public MobtimizationsForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.register(Mobtimizations.class);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandMisc.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public void worldTick(TickEvent.LevelTickEvent event) {
        if (Mobtimizations.testSpawningActive) {
            Level level = event.level;
            int huskOrZombieCount = 0;
            if (event.phase == TickEvent.Phase.END && level.m_46472_() == Level.f_46428_ && level.m_46467_() % 100L == 0L && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (Entity entity : serverLevel.m_8583_()) {
                    if (!(entity instanceof Zombie)) continue;
                    ++huskOrZombieCount;
                }
                int spawnMax = 1000;
                int spawnRange = 100;
                int spawnCount = 0;
                if (huskOrZombieCount < spawnMax) {
                    for (int i = 0; i < spawnMax - huskOrZombieCount; ++i) {
                        int playerCount = level.m_6907_().size();
                        Player player = (Player)level.m_6907_().get(CU.rand().nextInt(playerCount));
                        int x = Mth.m_14107_((double)(player.m_20182_().f_82479_ + (double)(CU.rand().nextFloat() * (float)spawnRange - CU.rand().nextFloat() * (float)spawnRange)));
                        int z = Mth.m_14107_((double)(player.m_20182_().f_82481_ + (double)(CU.rand().nextFloat() * (float)spawnRange - CU.rand().nextFloat() * (float)spawnRange)));
                        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                        Husk mob = new Husk(EntityType.f_20458_, level);
                        mob.m_6034_((double)x, (double)y, (double)z);
                        mob.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, (SpawnGroupData)null, (CompoundTag)null);
                        level.m_7967_((Entity)mob);
                        ++spawnCount;
                    }
                }
                System.out.println("spawned " + spawnCount + " husks");
            }
        }
    }
}

