/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.dryingbasin;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.compress.utils.Lists;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class DryingBasinRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<IInventoryFluid, RecipeDryingBasin, DryingBasinRecipeJEI> {
    private final List<ItemStack> inputItem;
    private final FluidStack inputFluid;
    private final ItemStack outputItem;
    private final FluidStack outputFluid;
    private final int duration;

    public DryingBasinRecipeJEI(RecipeDryingBasin recipe) {
        super(RegistryEntries.RECIPETYPE_DRYING_BASIN, (Recipe)recipe);
        this.inputItem = Arrays.stream(recipe.getInputIngredient().m_43908_()).collect(Collectors.toList());
        this.inputFluid = recipe.getInputFluid();
        this.outputItem = recipe.getOutputItemFirst();
        this.outputFluid = recipe.getOutputFluid();
        this.duration = recipe.getDuration();
    }

    protected DryingBasinRecipeJEI() {
        super(RegistryEntries.RECIPETYPE_DRYING_BASIN, null);
        this.inputItem = null;
        this.inputFluid = null;
        this.outputItem = null;
        this.outputFluid = null;
        this.duration = 0;
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    protected RecipeType<RecipeDryingBasin> getRecipeType() {
        return RegistryEntries.RECIPETYPE_DRYING_BASIN;
    }

    protected DryingBasinRecipeJEI newInstance(RecipeDryingBasin recipe) {
        return new DryingBasinRecipeJEI(recipe);
    }

    public static List<DryingBasinRecipeJEI> getAllRecipes() {
        return Lists.newArrayList(new DryingBasinRecipeJEI().createAllRecipes().iterator());
    }
}

