/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeSqueezer
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final NonNullList<IngredientChance> outputItems;
    private final FluidStack outputFluid;

    public RecipeSqueezer(ResourceLocation id, Ingredient inputIngredient, NonNullList<IngredientChance> outputItems, FluidStack outputFluid) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public NonNullList<IngredientChance> getOutputItems() {
        return this.outputItems;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.inputIngredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((IngredientChance)this.outputItems.get(0)).getIngredientFirst().m_41777_();
    }

    public NonNullList<IngredientChance> assemble(ItemStack inputItem) {
        return this.getOutputItems();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((IngredientChance)this.outputItems.get(0)).getIngredientFirst().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_SQUEEZER;
    }

    public RecipeType<?> m_6671_() {
        return RegistryEntries.RECIPETYPE_SQUEEZER;
    }

    public static class IngredientChance {
        private final Either<ItemStack, ItemStackFromIngredient> ingredient;
        private final float chance;

        public IngredientChance(Either<ItemStack, ItemStackFromIngredient> ingredient, float chance) {
            this.ingredient = Objects.requireNonNull(ingredient);
            this.chance = chance;
        }

        public Either<ItemStack, ItemStackFromIngredient> getIngredient() {
            return this.ingredient;
        }

        public ItemStack getIngredientFirst() {
            return (ItemStack)this.getIngredient().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
        }

        public float getChance() {
            return this.chance;
        }
    }
}

