/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.core.client.model.ModelHelpers;
import org.cyclops.integrateddynamics.core.client.model.VariableModelBaked;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;

public class VariableModel
implements UnbakedModel,
IUnbakedGeometry<VariableModel> {
    private final BlockModel base;

    public VariableModel(BlockModel base) {
        this.base = base;
    }

    public void loadSubModels(List<ResourceLocation> subModels) {
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            provider.loadModels(subModels);
        }
    }

    public static void addAdditionalModels(ImmutableSet.Builder<ResourceLocation> builder) {
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            builder.addAll(provider.getDependencies());
        }
    }

    public Collection<ResourceLocation> m_7970_() {
        if (this.base.getParentLocation() == null || this.base.getParentLocation().m_135815_().startsWith("builtin/")) {
            return Collections.emptyList();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.base.getParentLocation());
        VariableModel.addAdditionalModels((ImmutableSet.Builder<ResourceLocation>)builder);
        return builder.build();
    }

    public void m_5500_(Function<ResourceLocation, UnbakedModel> resolver) {
        this.base.m_5500_(resolver);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return this.m_7611_(baker, spriteGetter, modelState, modelLocation);
    }

    @Nullable
    public BakedModel m_7611_(ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
        Material textureName = this.base.m_111480_("layer0");
        BlockModel itemModel = ModelHelpers.MODEL_GENERATOR.m_111670_(spriteGetter, this.base);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(itemModel, itemModel.getOverrides(bakery, itemModel, spriteGetter), false);
        itemModel.f_111417_.put("layer0", Either.left((Object)textureName));
        TextureAtlasSprite textureAtlasSprite = spriteGetter.apply(textureName);
        builder.m_119528_(textureAtlasSprite);
        for (BakedQuad bakedQuad : UnbakedGeometryHelper.bakeElements((List)UnbakedGeometryHelper.createUnbakedItemElements((int)0, (SpriteContents)textureAtlasSprite.m_245424_(), (ForgeFaceData)ForgeFaceData.DEFAULT), $ -> textureAtlasSprite, (ModelState)modelState, (ResourceLocation)modelLocation)) {
            builder.m_119526_(bakedQuad);
        }
        BakedModel baseModel = builder.m_119533_();
        VariableModelBaked bakedModel = new VariableModelBaked(baseModel);
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            bakedModel.setSubModels(provider, provider.bakeOverlayModels(bakery, spriteGetter, modelState, modelLocation));
        }
        return bakedModel;
    }
}

