/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class BlockEntitySqueezer
extends CyclopsBlockEntity {
    private final SimpleInventory inventory = new SimpleInventory(1, 1){

        public boolean m_7013_(int slot, ItemStack itemStack) {
            return (Integer)BlockEntitySqueezer.this.m_58904_().m_8055_(BlockEntitySqueezer.this.m_58899_()).m_61143_((Property)BlockSqueezer.HEIGHT) == 1 && this.m_8020_(0).m_41619_() && super.m_7013_(slot, itemStack);
        }

        public void m_6836_(int slotId, ItemStack itemstack) {
            super.m_6836_(slotId, itemstack);
            BlockEntitySqueezer.this.itemHeight = 1;
            BlockEntitySqueezer.this.sendUpdate();
        }
    };
    private final SingleUseTank tank = new SingleUseTank(1000);
    @NBTPersist
    private int itemHeight = 1;
    private SingleCache<ItemStack, Optional<RecipeSqueezer>> recipeCache;

    public BlockEntitySqueezer(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_SQUEEZER, blockPos, blockState);
        this.addCapabilityInternal(ForgeCapabilities.ITEM_HANDLER, LazyOptional.of(() -> ((SimpleInventory)this.getInventory()).getItemHandler()));
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, LazyOptional.of(() -> new SimpleInventoryState(this.getInventory())));
        this.addCapabilityInternal(ForgeCapabilities.FLUID_HANDLER, LazyOptional.of(this::getTank));
        this.inventory.addDirtyMarkListener(() -> ((BlockEntitySqueezer)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).m_6596_());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeSqueezer>>(){

            public Optional<RecipeSqueezer> getNewValue(ItemStack key) {
                SimpleContainer recipeInput = new SimpleContainer(new ItemStack[]{key});
                return CraftingHelpers.findServerRecipe(BlockEntitySqueezer.this.getRegistry(), (Container)recipeInput, (Level)BlockEntitySqueezer.this.m_58904_());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.m_41728_((ItemStack)cacheKey, (ItemStack)newKey);
            }
        });
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerSqueezer<RecipeSqueezer>(() -> ((BlockEntitySqueezer)this).m_58904_(), RegistryEntries.RECIPETYPE_SQUEEZER)));
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(CompoundTag tag) {
        this.inventory.readFromNBT(tag, "inventory");
        this.tank.readFromNBT(tag, "tank");
        super.read(tag);
    }

    public void m_183515_(CompoundTag tag) {
        this.inventory.writeToNBT(tag, "inventory");
        this.tank.writeToNBT(tag, "tank");
        super.m_183515_(tag);
    }

    protected RecipeType<RecipeSqueezer> getRegistry() {
        return RegistryEntries.RECIPETYPE_SQUEEZER;
    }

    public Optional<RecipeSqueezer> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)this.getInventory().m_8020_(0).m_41777_());
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.sendUpdate();
        this.getInventory().m_6596_();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntitySqueezer> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySqueezer blockEntity) {
            Optional<RecipeSqueezer> recipeOptional;
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (!blockEntity.getTank().isEmpty()) {
                Direction.Axis axis = (Direction.Axis)blockState.m_61143_(BlockSqueezer.AXIS);
                Arrays.stream(Direction.AxisDirection.values()).map(axisDirection -> Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis)).forEach(side -> {
                    if (!blockEntity.getTank().isEmpty()) {
                        BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_121945_(side), (Direction)side.m_122424_(), (Capability)ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
                            FluidStack fluidStack = new FluidStack(blockEntity.getTank().getFluid(), Math.min(100, blockEntity.getTank().getFluidAmount()));
                            if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                                int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                blockEntity.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            }
                        });
                    }
                });
            } else if (blockEntity.itemHeight == 7 && (recipeOptional = blockEntity.getCurrentRecipe()).isPresent()) {
                RecipeSqueezer recipe = recipeOptional.get();
                ItemStack oldItem = blockEntity.getInventory().m_8020_(0);
                blockEntity.getInventory().m_6836_(0, ItemStack.f_41583_);
                for (RecipeSqueezer.IngredientChance itemStackChance : recipe.assemble(oldItem)) {
                    if (itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= level.f_46441_.m_188501_())) continue;
                    ItemStack resultStack = itemStackChance.getIngredientFirst().m_41777_();
                    for (Direction side2 : Direction.values()) {
                        IItemHandler itemHandler;
                        if (resultStack.m_41619_() || side2 == Direction.UP || (itemHandler = (IItemHandler)BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_121945_(side2), (Direction)side2.m_122424_(), (Capability)ForgeCapabilities.ITEM_HANDLER).orElse(null)) == null) continue;
                        resultStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)resultStack, (boolean)false);
                    }
                    if (resultStack.m_41619_()) continue;
                    ItemStackHelpers.spawnItemStack((Level)level, (BlockPos)pos, (ItemStack)resultStack);
                }
                if (!recipe.getOutputFluid().isEmpty()) {
                    blockEntity.getTank().fill(recipe.getOutputFluid(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }
}

