/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.logicprogrammer.event.LogicProgrammerVariableFacadeCreatedEvent;

public class VariableCreatedTrigger
extends SimpleCriterionTrigger<Instance> {
    private final ResourceLocation ID = new ResourceLocation("integrateddynamics", "variable_created");

    public VariableCreatedTrigger() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation m_7295_() {
        return this.ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        JsonElement blockElement = json.get("block");
        Block block = null;
        if (blockElement != null && !blockElement.isJsonNull() && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()))) == null) {
            throw new JsonSyntaxException("No block found with name: " + json.get("block").getAsString());
        }
        return new Instance(this.m_7295_(), entityPredicate, block, VariableFacadePredicate.deserialize(ValueDeseralizationContext.ofAllEnabled(), json.get("variable_facade")));
    }

    public void test(ServerPlayer player, LogicProgrammerVariableFacadeCreatedEvent event) {
        this.m_66234_(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onEvent(LogicProgrammerVariableFacadeCreatedEvent event) {
        if (event.getPlayer() != null && event.getPlayer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getPlayer(), event);
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance
    implements ICriterionInstanceTestable<LogicProgrammerVariableFacadeCreatedEvent> {
        private final Block block;
        private final VariableFacadePredicate variableFacadePredicate;

        public Instance(ResourceLocation criterionIn, ContextAwarePredicate player, @Nullable Block block, VariableFacadePredicate variableFacadePredicate) {
            super(criterionIn, player);
            this.block = block;
            this.variableFacadePredicate = variableFacadePredicate;
        }

        public boolean test(ServerPlayer player, LogicProgrammerVariableFacadeCreatedEvent event) {
            return (this.block == null || event.getBlockState().m_60734_() == this.block) && this.variableFacadePredicate.test(event.getVariableFacade());
        }
    }
}

