/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.command.hand;

import com.cursee.monolib.core.command.hand.HandArgument;
import com.cursee.monolib.core.serialization.Serializers;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class HandArgumentHelper {
    public static int printHeldStack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OutputType type = HandArgument.get(context);
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (sender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sender;
            String stackOutput = type.converter.apply(living.m_21205_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)stackOutput).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, stackOutput))), false);
        }
        return 1;
    }

    public static enum OutputType {
        string(OutputType::getAsString),
        ingredient(OutputType::getAsIngredient),
        stack_json(OutputType::getAsStackJson),
        snbt(OutputType::getAsSNBT),
        id(OutputType::getAsID),
        tags(OutputType::getTags);

        private final Function<ItemStack, String> converter;

        private OutputType(Function<ItemStack, String> converter) {
            this.converter = converter;
        }

        private static String getAsString(ItemStack stack) {
            return stack.toString();
        }

        private static String getAsIngredient(ItemStack stack) {
            return Serializers.INGREDIENT.toJSON(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})).toString();
        }

        private static String getAsStackJson(ItemStack stack) {
            return Serializers.ITEM_STACK.toJSON(stack).toString();
        }

        public static String getAsSNBT(ItemStack stack) {
            return stack.m_41739_(new CompoundTag()).m_7916_();
        }

        public static String getAsID(ItemStack stack) {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            return id != null ? id.toString() : null;
        }

        public static String getTags(ItemStack stack) {
            StringJoiner joiner = new StringJoiner("\n");
            stack.m_41720_().m_204114_().m_203616_().forEach(tag -> joiner.add(tag.f_203868_().toString()));
            return joiner.toString();
        }
    }
}

