/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.blocks.block_entities;

import com.song.castle_in_the_sky.blocks.BlockRegister;
import com.song.castle_in_the_sky.blocks.FakeBeacon;
import com.song.castle_in_the_sky.blocks.LaputaCore;
import com.song.castle_in_the_sky.blocks.block_entities.TERegister;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.effects.EffectRegister;
import com.song.castle_in_the_sky.items.ItemsRegister;
import com.song.castle_in_the_sky.network.Channel;
import com.song.castle_in_the_sky.network.LaputaTESynPkt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class LaputaCoreBE
extends BlockEntity {
    private boolean isActive = false;
    private boolean isDestroying = false;
    private int destroyProgress = 0;
    private boolean initialUpdated = false;
    private Vec3 activatedInitPos = new Vec3(0.0, 0.0, 0.0);
    public static final int ANIMATION_TIME = 200;
    private static final int DESTRUCTION_TICKS = 200;
    private static final int DESTRUCTION_TIME_PER_TICK = 10;
    private static final int DESTROY_MAX = 2200;
    private static final int RADIUS = 80;
    private static final int RADIUS2 = 6400;
    private static final int HEIGHT_MIN = -14;
    private static final int HEIGHT_MAX = 100;
    private static final ArrayList<ArrayList<Integer>> DESTRUCTION_PATTERN = new ArrayList();
    private static final int PROGRESS_EACH_TICK;
    private static final Set<String> DESTRUCTION_BLACKLIST;

    public LaputaCoreBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)TERegister.LAPUTA_CORE_TE_TYPE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, LaputaCoreBE laputaCoreTE) {
        if (!level.m_5776_()) {
            if (!laputaCoreTE.initialUpdated) {
                laputaCoreTE.setActive((Boolean)blockState.m_61143_((Property)LaputaCore.POWERED));
                laputaCoreTE.initialUpdated = true;
            }
            if (laputaCoreTE.isDestroying) {
                boolean drops = (Boolean)ConfigCommon.DESTRUCTION_DROPS.get();
                if (laputaCoreTE.destroyProgress % 3 == 0) {
                    Channel.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)laputaCoreTE.m_58899_().m_123341_(), (double)laputaCoreTE.m_58899_().m_123342_(), (double)laputaCoreTE.m_58899_().m_123343_(), (double)20.0, (ResourceKey)Level.f_46428_)), (Object)new LaputaTESynPkt(laputaCoreTE.isDestroying, laputaCoreTE.isActive(), laputaCoreTE.m_58899_(), laputaCoreTE.getActivatedInitPos(), laputaCoreTE.destroyProgress));
                }
                if (laputaCoreTE.destroyProgress == 0) {
                    for (ArrayList<Integer> pos : DESTRUCTION_PATTERN) {
                        BlockPos target = blockPos.m_7918_(pos.get(0).intValue(), pos.get(1).intValue(), pos.get(2).intValue());
                        if (level.m_6425_(target) == Fluids.f_76191_.m_76145_()) continue;
                        level.m_46597_(target, Blocks.f_50016_.m_49966_());
                    }
                    level.m_46597_(blockPos.m_7918_(0, -1, 0), ((FakeBeacon)((Object)BlockRegister.FAKE_BEACON.get())).m_49966_());
                }
                if (laputaCoreTE.destroyProgress >= 200) {
                    if (laputaCoreTE.destroyProgress >= 2200) {
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dz = -1; dz <= 1; ++dz) {
                                level.m_46597_(blockPos.m_7918_(dx, -1, dz), ((FakeBeacon)((Object)BlockRegister.FAKE_BEACON.get())).m_49966_());
                            }
                        }
                        level.m_46961_(blockPos, false);
                        level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new ItemStack((ItemLike)ItemsRegister.LAPUTA_MINIATURE.get())));
                        if (ModList.get().isLoaded("botania")) {
                            ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania:laputa_shard")));
                            itemStack.m_41784_().m_128405_("level", 20);
                            level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), itemStack));
                        }
                    } else {
                        int exceed;
                        if (laputaCoreTE.destroyProgress == 200) {
                            level.m_254849_(null, (double)blockPos.m_123341_() + 0.5, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.5, 1.5f, Level.ExplosionInteraction.NONE);
                        }
                        if ((exceed = laputaCoreTE.destroyProgress - 200) % 10 == 0) {
                            int process_tick = exceed / 10;
                            for (int i = process_tick * PROGRESS_EACH_TICK; i < (process_tick + 1) * PROGRESS_EACH_TICK && i < DESTRUCTION_PATTERN.size(); ++i) {
                                ArrayList<Integer> pos = DESTRUCTION_PATTERN.get(i);
                                BlockPos target = blockPos.m_7918_(pos.get(0).intValue(), pos.get(1).intValue(), pos.get(2).intValue());
                                if (DESTRUCTION_BLACKLIST.contains(ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(target).m_60734_()).toString())) continue;
                                level.m_46961_(target, drops);
                            }
                        }
                    }
                }
                ++laputaCoreTE.destroyProgress;
                laputaCoreTE.m_6596_();
            } else if (laputaCoreTE.isActive() && ((Boolean)ConfigCommon.NO_GRIEF_IN_CASTLE.get()).booleanValue() && level.m_46467_() % 40L == 0L) {
                for (Player playerEntity : level.m_6907_()) {
                    if (!playerEntity.m_9236_().m_46472_().m_135782_().toString().equals("minecraft:overworld") || !playerEntity.m_20183_().m_123314_((Vec3i)laputaCoreTE.m_58899_(), (double)((Integer)ConfigCommon.LAPUTA_CORE_EFFECT_RANGE.get()).intValue())) continue;
                    playerEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegister.SACRED_CASTLE_EFFECT.get(), 100));
                }
                Channel.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)laputaCoreTE.m_58899_().m_123341_(), (double)laputaCoreTE.m_58899_().m_123342_(), (double)laputaCoreTE.m_58899_().m_123343_(), (double)20.0, (ResourceKey)Level.f_46428_)), (Object)new LaputaTESynPkt(laputaCoreTE.isDestroying, laputaCoreTE.isActive(), laputaCoreTE.m_58899_()));
            }
        }
    }

    public void setDestroying(boolean destroying) {
        this.isDestroying = destroying;
    }

    public boolean isDestroying() {
        return this.isDestroying;
    }

    public Vec3 getActivatedInitPos() {
        return this.activatedInitPos;
    }

    public void setActivatedInitPos(Vec3 activatedInitPos) {
        this.activatedInitPos = activatedInitPos;
    }

    public int getDestroyProgress() {
        return this.destroyProgress;
    }

    public void setDestroyProgress(int destroyProgress) {
        this.destroyProgress = destroyProgress;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Channel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new LaputaTESynPkt(this.isDestroying, this.isActive, this.m_58899_()));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Channel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new LaputaTESynPkt(this.isDestroying, this.isActive, this.m_58899_()));
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("is_active", this.isActive());
        nbt.m_128379_("isDestroying", this.isDestroying);
        nbt.m_128405_("destroyProgress", this.destroyProgress);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.setActive(tag.m_128471_("is_active"));
        this.setDestroying(tag.m_128471_("isDestroying"));
        this.destroyProgress = tag.m_128451_("destroyProgress");
    }

    @NotNull
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("is_active", this.isActive());
        tag.m_128379_("isDestroying", this.isDestroying);
        tag.m_128405_("destroyProgress", this.destroyProgress);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.setActive(tag.m_128471_("is_active"));
        this.setDestroying(tag.m_128471_("isDestroying"));
        this.destroyProgress = tag.m_128451_("destroyProgress");
    }

    static {
        for (int dx = -80; dx <= 80; ++dx) {
            for (int dy = -14; dy <= 100; ++dy) {
                for (int dz = -80; dz <= 80; ++dz) {
                    if (dx * dx + dz * dz > 6400 || dx == 0 && dy == -1 && dz == 0) continue;
                    ArrayList<Integer> tmp = new ArrayList<Integer>(Arrays.asList(dx, dy, dz));
                    DESTRUCTION_PATTERN.add(tmp);
                }
            }
        }
        Collections.shuffle(DESTRUCTION_PATTERN);
        PROGRESS_EACH_TICK = DESTRUCTION_PATTERN.size() / 200 + 1;
        DESTRUCTION_BLACKLIST = new HashSet<String>(Arrays.asList("castle_in_the_sky:laputa_core", "minecraft:spruce_log", "minecraft:spruce_wood", "minecraft:shroomlight", "minecraft:spawner", "minecraft:chest", "minecraft:barrel"));
    }
}

