/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.blocks;

import com.song.castle_in_the_sky.blocks.block_entities.LaputaCoreBE;
import com.song.castle_in_the_sky.blocks.block_entities.TERegister;
import com.song.castle_in_the_sky.network.Channel;
import com.song.castle_in_the_sky.network.LaputaTESynPkt;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class LaputaCore
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public LaputaCore() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(-1.0f, 3600000.0f).m_60953_(LaputaCore.litBlockEmission(15)).m_222994_().m_60955_());
    }

    private static ToIntFunction<BlockState> litBlockEmission(int light) {
        return blockState -> (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_) != false ? light : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{POWERED});
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighbor, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!world.m_5776_()) {
            BlockEntity tileEntity = world.m_7702_(pos);
            boolean hasSignal = world.m_276867_(pos);
            if (hasSignal) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                if (tileEntity instanceof LaputaCoreBE) {
                    ((LaputaCoreBE)tileEntity).setActive(true);
                    tileEntity.m_6596_();
                }
            } else {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
                if (tileEntity instanceof LaputaCoreBE) {
                    ((LaputaCoreBE)tileEntity).setActive(false);
                    tileEntity.m_6596_();
                }
            }
            if (tileEntity instanceof LaputaCoreBE) {
                Channel.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new LaputaTESynPkt(((LaputaCoreBE)tileEntity).isDestroying(), hasSignal, pos));
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && player.m_21120_(interactionHand).m_41720_() == Items.f_41829_ && (blockEntity = level.m_7702_(blockPos)) instanceof LaputaCoreBE) {
            ((LaputaCoreBE)blockEntity).setDestroying(true);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockItemUseContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return BOTTOM_AABB;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        LaputaCoreBE result = new LaputaCoreBE(blockPos, blockState);
        result.setActive((Boolean)blockState.m_61143_((Property)POWERED));
        result.m_6596_();
        return result;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return LaputaCore.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)TERegister.LAPUTA_CORE_TE_TYPE.get()), LaputaCoreBE::tick);
    }
}

