/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.load;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.GlyphProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.glyphs.SpecialGlyphs;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.datagen.load.DatagenLoader;
import org.moddingx.libx.impl.reflect.ReflectionHacks;

public class DatagenFontLoader {
    public static final ResourceLocation ZERO_WIDTH_FONT = LibX.getInstance().resource("zero_width");
    public static final StringSplitter MISSING = new StringSplitter((cp, style) -> ZERO_WIDTH_FONT.equals((Object)style.m_131192_()) ? 0.0f : SpecialGlyphs.MISSING.m_83827_(style.m_131154_()));
    private static StringSplitter fontMetrics;

    public static StringSplitter getFontMetrics(@Nullable ExistingFileHelper fileHelper) {
        if (fontMetrics == null) {
            if (fileHelper == null) {
                throw new RuntimeException("Can't load font without file helper.");
            }
            try {
                LibX.logger.info("Loading font metrics during datagen.");
                ResourceManager rm = DatagenLoader.resources(fileHelper, PackType.CLIENT_RESOURCES);
                FontManager mgr = ReflectionHacks.newInstance(FontManager.class);
                FontManager.Preparation preparation = (FontManager.Preparation)mgr.m_284410_(rm, Runnable::run).get(0L, TimeUnit.NANOSECONDS);
                Map<ResourceLocation, List> providerMap = preparation.f_283921_().entrySet().stream().map(entry -> {
                    ResourceLocation fontId = (ResourceLocation)entry.getKey();
                    ArrayList list = new ArrayList((Collection)entry.getValue());
                    Collections.reverse(list);
                    return Map.entry(fontId, Collections.unmodifiableList(list));
                }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
                List defaultGlyphProviders = providerMap.getOrDefault(Style.f_131100_, List.of());
                fontMetrics = new StringSplitter((cp, style) -> {
                    if (ZERO_WIDTH_FONT.equals((Object)style.m_131192_())) {
                        return 0.0f;
                    }
                    for (GlyphProvider provider : providerMap.getOrDefault(style.m_131192_(), defaultGlyphProviders)) {
                        GlyphInfo glyph = provider.m_214022_(cp);
                        if (glyph == null) continue;
                        return glyph.m_83827_(style.m_131154_());
                    }
                    return SpecialGlyphs.MISSING.m_83827_(style.m_131154_());
                });
                LibX.logger.info("Font loading complete.");
            }
            catch (Exception e) {
                LibX.logger.error("Failed to load font metrics during datagen. Using Missing glyph provider.", (Throwable)e);
                fontMetrics = MISSING;
            }
        }
        return fontMetrics;
    }
}

