/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.modinit.register;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.processor.Processor;
import org.moddingx.libx.annotation.registration.PlainRegisterable;
import org.moddingx.libx.annotation.registration.Reg;
import org.moddingx.libx.annotation.registration.RegisterClass;

public class RegisterClassModifyProcessor
extends Processor {
    private static final Set<Class<? extends Annotation>> MODIFY_ANNOTATIONS = Set.of(Reg.Exclude.class, Reg.Name.class);

    @Override
    public Class<?>[] getTypes() {
        return (Class[])Stream.concat(Stream.of(Reg.class, PlainRegisterable.class), MODIFY_ANNOTATIONS.stream()).toArray(Class[]::new);
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Reg.class)) {
            this.messager().printMessage(Diagnostic.Kind.ERROR, "@Reg is a container annotation an can't be directly used on elements.", element);
        }
        for (Class clazz : MODIFY_ANNOTATIONS) {
            for (Element element : roundEnv.getElementsAnnotatedWith(clazz)) {
                if (!(element.getKind() == ElementKind.FIELD && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.FINAL))) {
                    this.messager().printMessage(Diagnostic.Kind.ERROR, "@" + clazz.getSimpleName() + " can only be used on public static final fields.", element);
                    continue;
                }
                if (element.getEnclosingElement().getKind() != ElementKind.CLASS || element.getEnclosingElement().getAnnotation(RegisterClass.class) == null) {
                    this.messager().printMessage(Diagnostic.Kind.ERROR, "@" + clazz.getSimpleName() + " can only be used on in classes annotated with @RegisterClass.", element);
                    continue;
                }
                if (clazz == Reg.Exclude.class || element.getAnnotation(Reg.Exclude.class) == null) continue;
                this.messager().printMessage(Diagnostic.Kind.ERROR, "@" + clazz.getSimpleName() + " can't be used on fields excluded from registration.", element);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PlainRegisterable.class)) {
            TypeElement typeElement;
            if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ANNOTATION_TYPE) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "@PlainRegisterable is disallowed on interfaces.", element);
                continue;
            }
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.RECORD) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "@PlainRegisterable can only be added to classes.", element);
                continue;
            }
            if (!(element instanceof TypeElement) || this.subTypeErasure((typeElement = (TypeElement)element).asType(), this.forClass("org.moddingx.libx.registration.Registerable"))) continue;
            this.messager().printMessage(Diagnostic.Kind.WARNING, "Class annotated with @PlainRegisterable does not implement Registerable.", element);
        }
    }
}

