/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class TreeCreator {
    public static TreeObject create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        Optional treeOptional = TreeObject.codec(id).parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
        if (treeOptional.isPresent()) {
            TreeObject treeObject = (TreeObject)treeOptional.get();
            ColorUtil.getCacheColor((String)treeObject.getLeafColor());
            ColorUtil.getCacheColor((String)treeObject.getLogColor());
            ColorUtil.getCacheColor((String)treeObject.getPlankColor());
            if (treeObject.hasFruit()) {
                ColorUtil.getCacheColor((String)treeObject.getFruit().ripeColor());
                ColorUtil.getCacheColor((String)treeObject.getFruit().unripeColor());
            }
            TreeRegistrator.registerTree(treeObject);
            return treeObject;
        }
        ProductiveTrees.LOGGER.info("failed to read tree configuration for " + id);
        return null;
    }
}

