/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivelib.util.RecipeUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class ThermalInsulatorRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final ItemStack log;
    private final ItemStack sapling;
    private final ItemStack fruit;
    private final float fruitChance;
    public final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public ThermalInsulatorRecipeBuilder(Ingredient ingredient, ItemStack log, ItemStack sapling, ItemStack fruit, float fruitChance) {
        this.ingredient = ingredient;
        this.log = log;
        this.sapling = sapling;
        this.fruit = fruit;
        this.fruitChance = fruitChance;
    }

    public static ThermalInsulatorRecipeBuilder direct(Ingredient saplings, ItemStack log, ItemStack sapling, ItemStack fruit, float fruitChance) {
        return new ThermalInsulatorRecipeBuilder(saplings, log, sapling, fruit, fruitChance);
    }

    public static ThermalInsulatorRecipeBuilder tree(Block log, Block sapling, ItemStack fruit, float fruitChance) {
        return ThermalInsulatorRecipeBuilder.direct(Ingredient.m_43929_((ItemLike[])new ItemLike[]{sapling}), new ItemStack((ItemLike)log), new ItemStack((ItemLike)sapling), fruit, fruitChance);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        return this;
    }

    public Item m_142372_() {
        return this.log.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.ingredient, this.log, this.sapling, this.fruit, this.fruitChance, this.advancement));
    }

    record Result(ResourceLocation id, Ingredient ingredient, ItemStack log, ItemStack sapling, ItemStack fruit, float fruitChance, Advancement.Builder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.ingredient.m_43942_());
            JsonArray result = new JsonArray();
            result.add((JsonElement)RecipeUtil.itemChanceToJson((ItemStack)this.log, (float)6.0f));
            result.add((JsonElement)RecipeUtil.itemChanceToJson((ItemStack)this.sapling, (float)1.1f));
            if (!this.fruit.m_41619_()) {
                result.add((JsonElement)RecipeUtil.itemChanceToJson((ItemStack)this.fruit, (float)this.fruitChance));
            }
            json.add("result", (JsonElement)result);
            json.addProperty("energy_mod", (Number)3.0);
            json.addProperty("water_mod", (Number)3.0);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("thermal:insolator"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.id.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/");
        }
    }
}

