/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.kambrik.bridge;

import com.google.auto.service.AutoService;
import io.ejekta.kambrik.Kambrik;
import io.ejekta.kambrik.bridge.BridgeSide;
import io.ejekta.kambrik.bridge.KambrikSharedApi;
import io.ejekta.kambrik.ext.ExtRegistryKt;
import io.ejekta.kambrik.message.ClientMsg;
import io.ejekta.kambrik.message.INetworkLink;
import io.ejekta.kambrik.message.ServerMsg;
import io.ejekta.kambrik.registration.KambrikAutoRegistrar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0003123B\u0007\u00a2\u0006\u0004\b/\u00100J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ;\u0010\u0013\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0019\u001a\u00020\u0007\"\b\b\u0000\u0010\u0016*\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001c\u001a\u00020\u0007\"\b\b\u0000\u0010\u0016*\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001aJ?\u0010\"\u001a\u00020!\"\b\b\u0000\u0010\u0016*\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010#J7\u0010$\u001a\u00020!\"\b\b\u0000\u0010\u0016*\u00020\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b$\u0010%R'\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u00040&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010.\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00064"}, d2={"Lio/ejekta/kambrik/bridge/KambrikSharedApiForge;", "Lio/ejekta/kambrik/bridge/KambrikSharedApi;", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraftforge/network/simple/SimpleChannel;", "createDummyChannel", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraftforge/network/simple/SimpleChannel;", "", "isOnClient", "()Z", "isOnServer", "T", "Lio/ejekta/kambrik/registration/KambrikAutoRegistrar;", "autoReg", "Lnet/minecraft/core/Registry;", "reg", "", "thingId", "obj", "register", "(Lio/ejekta/kambrik/registration/KambrikAutoRegistrar;Lnet/minecraft/core/Registry;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "Lio/ejekta/kambrik/message/ClientMsg;", "M", "Lio/ejekta/kambrik/message/INetworkLink;", "link", "registerClientMessage", "(Lio/ejekta/kambrik/message/INetworkLink;Lnet/minecraft/resources/ResourceLocation;)Z", "Lio/ejekta/kambrik/message/ServerMsg;", "registerServerMessage", "msg", "Lnet/minecraft/server/level/ServerPlayer;", "player", "msgId", "", "sendMsgToClient", "(Lio/ejekta/kambrik/message/INetworkLink;Lio/ejekta/kambrik/message/ClientMsg;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/resources/ResourceLocation;)V", "sendMsgToServer", "(Lio/ejekta/kambrik/message/INetworkLink;Lio/ejekta/kambrik/message/ServerMsg;Lnet/minecraft/resources/ResourceLocation;)V", "", "channelMap", "Ljava/util/Map;", "getChannelMap", "()Ljava/util/Map;", "Lio/ejekta/kambrik/bridge/BridgeSide;", "getSide", "()Lio/ejekta/kambrik/bridge/BridgeSide;", "side", "<init>", "()V", "ForgeClientMsgWrapper", "ForgeMsgWrapper", "ForgeServerMsgWrapper", "Kambrik"})
@AutoService(value={KambrikSharedApi.class})
public final class KambrikSharedApiForge
implements KambrikSharedApi {
    @NotNull
    private final Map<INetworkLink<?>, SimpleChannel> channelMap = new LinkedHashMap();

    @Override
    @NotNull
    public BridgeSide getSide() {
        return BridgeSide.FORGE;
    }

    @Override
    public boolean isOnClient() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public boolean isOnServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    @NotNull
    public final Map<INetworkLink<?>, SimpleChannel> getChannelMap() {
        return this.channelMap;
    }

    @NotNull
    public final SimpleChannel createDummyChannel(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String version = "1";
        SimpleChannel simpleChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)id, () -> KambrikSharedApiForge.createDummyChannel$lambda$0(version), version::equals, version::equals);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChannel, (String)"newSimpleChannel(\n      \u2026version::equals\n        )");
        return simpleChannel;
    }

    @Override
    public <M extends ServerMsg> boolean registerServerMessage(@NotNull INetworkLink<M> link, @NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter(link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SimpleChannel dummy = this.createDummyChannel(id);
        ForgeServerMsgWrapper<M> wrapper = new ForgeServerMsgWrapper<M>(link);
        this.channelMap.put(link, dummy);
        dummy.registerMessage(1, JvmClassMappingKt.getJavaClass(link.getKClass()), wrapper::writer, wrapper::reader, wrapper::handler);
        return dummy != null;
    }

    @Override
    public <M extends ClientMsg> boolean registerClientMessage(@NotNull INetworkLink<M> link, @NotNull ResourceLocation id) {
        SimpleChannel dummy;
        block0: {
            Intrinsics.checkNotNullParameter(link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            dummy = this.createDummyChannel(id);
            ForgeClientMsgWrapper<M> wrapper = new ForgeClientMsgWrapper<M>(link);
            this.channelMap.put(link, dummy);
            SimpleChannel simpleChannel = dummy;
            if (simpleChannel == null) break block0;
            simpleChannel.registerMessage(1, JvmClassMappingKt.getJavaClass(link.getKClass()), wrapper::writer, wrapper::reader, wrapper::handler);
        }
        return dummy != null;
    }

    @Override
    public <M extends ServerMsg> void sendMsgToServer(@NotNull INetworkLink<M> link, @NotNull M msg, @NotNull ResourceLocation msgId) {
        SimpleChannel channel;
        Intrinsics.checkNotNullParameter(link, (String)"link");
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)msgId, (String)"msgId");
        SimpleChannel simpleChannel = channel = this.channelMap.get(link);
        Intrinsics.checkNotNull((Object)simpleChannel);
        simpleChannel.sendToServer(msg);
    }

    @Override
    public <M extends ClientMsg> void sendMsgToClient(@NotNull INetworkLink<M> link, @NotNull M msg, @NotNull ServerPlayer player, @NotNull ResourceLocation msgId) {
        SimpleChannel channel;
        Intrinsics.checkNotNullParameter(link, (String)"link");
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)msgId, (String)"msgId");
        SimpleChannel simpleChannel = channel = this.channelMap.get(link);
        Intrinsics.checkNotNull((Object)simpleChannel);
        simpleChannel.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T> T register(@NotNull KambrikAutoRegistrar autoReg, @NotNull Registry<T> reg, @NotNull String thingId, T obj) {
        Intrinsics.checkNotNullParameter((Object)autoReg, (String)"autoReg");
        Intrinsics.checkNotNullParameter(reg, (String)"reg");
        Intrinsics.checkNotNullParameter((Object)thingId, (String)"thingId");
        ExtRegistryKt.register(reg, Kambrik.INSTANCE.idOf(thingId), obj);
        return obj;
    }

    private static final String createDummyChannel$lambda$0(String $version) {
        Intrinsics.checkNotNullParameter((Object)$version, (String)"$version");
        return $version;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00028\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nR \u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/ejekta/kambrik/bridge/KambrikSharedApiForge$ForgeClientMsgWrapper;", "Lio/ejekta/kambrik/message/ClientMsg;", "MSG", "Lio/ejekta/kambrik/bridge/KambrikSharedApiForge$ForgeMsgWrapper;", "msg", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "ctx", "", "handler", "(Lio/ejekta/kambrik/message/ClientMsg;Ljava/util/function/Supplier;)V", "Lio/ejekta/kambrik/message/INetworkLink;", "link", "Lio/ejekta/kambrik/message/INetworkLink;", "getLink", "()Lio/ejekta/kambrik/message/INetworkLink;", "<init>", "(Lio/ejekta/kambrik/message/INetworkLink;)V", "Kambrik"})
    public static final class ForgeClientMsgWrapper<MSG extends ClientMsg>
    extends ForgeMsgWrapper<MSG> {
        @NotNull
        private final INetworkLink<MSG> link;

        public ForgeClientMsgWrapper(@NotNull INetworkLink<MSG> link) {
            Intrinsics.checkNotNullParameter(link, (String)"link");
            super(link);
            this.link = link;
        }

        @Override
        @NotNull
        public INetworkLink<MSG> getLink() {
            return this.link;
        }

        @Override
        public void handler(@NotNull MSG msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter(msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            NetworkEvent.Context $this$handler_u24lambda_u241 = ctx.get();
            boolean bl = false;
            $this$handler_u24lambda_u241.enqueueWork(() -> ForgeClientMsgWrapper.handler$lambda$1$lambda$0(msg));
            $this$handler_u24lambda_u241.setPacketHandled(true);
        }

        private static final void handler$lambda$1$lambda$0(ClientMsg $msg) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            Minecraft minecraft = Minecraft.m_91087_();
            Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance()");
            $msg.onClientReceived(new ClientMsg.MsgContext(minecraft));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u0015\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00028\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H&\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/ejekta/kambrik/bridge/KambrikSharedApiForge$ForgeMsgWrapper;", "", "MSG", "msg", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "ctx", "", "handler", "(Ljava/lang/Object;Ljava/util/function/Supplier;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buff", "reader", "(Lnet/minecraft/network/FriendlyByteBuf;)Ljava/lang/Object;", "writer", "(Ljava/lang/Object;Lnet/minecraft/network/FriendlyByteBuf;)V", "Lio/ejekta/kambrik/message/INetworkLink;", "link", "Lio/ejekta/kambrik/message/INetworkLink;", "getLink", "()Lio/ejekta/kambrik/message/INetworkLink;", "<init>", "(Lio/ejekta/kambrik/message/INetworkLink;)V", "Kambrik"})
    public static abstract class ForgeMsgWrapper<MSG> {
        @NotNull
        private final INetworkLink<MSG> link;

        public ForgeMsgWrapper(@NotNull INetworkLink<MSG> link) {
            Intrinsics.checkNotNullParameter(link, (String)"link");
            this.link = link;
        }

        @NotNull
        public INetworkLink<MSG> getLink() {
            return this.link;
        }

        public final void writer(@NotNull MSG msg, @NotNull FriendlyByteBuf buff) {
            Intrinsics.checkNotNullParameter(msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
            buff.m_130070_(this.getLink().serializePacket(msg));
        }

        @NotNull
        public final MSG reader(@NotNull FriendlyByteBuf buff) {
            Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
            INetworkLink<MSG> iNetworkLink = this.getLink();
            String string = buff.m_130277_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buff.readString()");
            return iNetworkLink.deserializePacket(string);
        }

        public abstract void handler(@NotNull MSG var1, @NotNull Supplier<NetworkEvent.Context> var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00028\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nR \u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lio/ejekta/kambrik/bridge/KambrikSharedApiForge$ForgeServerMsgWrapper;", "Lio/ejekta/kambrik/message/ServerMsg;", "MSG", "Lio/ejekta/kambrik/bridge/KambrikSharedApiForge$ForgeMsgWrapper;", "msg", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "ctx", "", "handler", "(Lio/ejekta/kambrik/message/ServerMsg;Ljava/util/function/Supplier;)V", "Lio/ejekta/kambrik/message/INetworkLink;", "link", "Lio/ejekta/kambrik/message/INetworkLink;", "getLink", "()Lio/ejekta/kambrik/message/INetworkLink;", "<init>", "(Lio/ejekta/kambrik/message/INetworkLink;)V", "Kambrik"})
    public static final class ForgeServerMsgWrapper<MSG extends ServerMsg>
    extends ForgeMsgWrapper<MSG> {
        @NotNull
        private final INetworkLink<MSG> link;

        public ForgeServerMsgWrapper(@NotNull INetworkLink<MSG> link) {
            Intrinsics.checkNotNullParameter(link, (String)"link");
            super(link);
            this.link = link;
        }

        @Override
        @NotNull
        public INetworkLink<MSG> getLink() {
            return this.link;
        }

        @Override
        public void handler(@NotNull MSG msg, @NotNull Supplier<NetworkEvent.Context> ctx) {
            Intrinsics.checkNotNullParameter(msg, (String)"msg");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            NetworkEvent.Context $this$handler_u24lambda_u241 = ctx.get();
            boolean bl = false;
            $this$handler_u24lambda_u241.enqueueWork(() -> ForgeServerMsgWrapper.handler$lambda$1$lambda$0(msg, $this$handler_u24lambda_u241));
            $this$handler_u24lambda_u241.setPacketHandled(true);
        }

        private static final void handler$lambda$1$lambda$0(ServerMsg $msg, NetworkEvent.Context $this_run) {
            Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
            Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
            ServerPlayer serverPlayer = $this_run.getSender();
            Intrinsics.checkNotNull((Object)serverPlayer);
            $msg.onServerReceived(new ServerMsg.MsgContext(serverPlayer));
        }
    }
}

