/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.config.ModConfig;
import com.saphienyako.feywild.entity.base.FeyBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record ToggleFollowPlayerMessage(int entityId, boolean followingPlayer, BlockPos currentBlockPos) {
    public static void encode(ToggleFollowPlayerMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId());
        buffer.writeBoolean(msg.followingPlayer());
        buffer.m_130064_(msg.currentBlockPos());
    }

    public static ToggleFollowPlayerMessage decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        boolean followingPlayer = buffer.readBoolean();
        BlockPos currentBlockPos = buffer.m_130135_();
        return new ToggleFollowPlayerMessage(id, followingPlayer, currentBlockPos);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        FeyBase entity;
        Level level = supplier.get().getSender().m_9236_();
        if (this.entityId() != -1 && (entity = (FeyBase)level.m_6815_(this.entityId)) != null) {
            entity.setFollowingPlayer(this.followingPlayer);
            if (!this.followingPlayer) {
                Objects.requireNonNull(supplier.get().getSender()).m_213846_(entity.getFeyStayMessage());
                if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue() && entity.getVoiceActive().booleanValue()) {
                    level.m_5594_(null, entity.m_20183_(), entity.getStaySound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                entity.setSummonPos(this.currentBlockPos);
            } else {
                Objects.requireNonNull(supplier.get().getSender()).m_213846_(entity.getFeyFollowMessage());
                if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue() && entity.getVoiceActive().booleanValue()) {
                    level.m_5594_(null, entity.m_20183_(), entity.getFollowSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
        }
    }
}

