/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.entity.Alignment;
import com.saphienyako.feywild.network.handler.OpenMenuMessageClientHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public record OpenMenuMessage(Component name, int entityId, Alignment alignment, boolean followingPlayer, BlockPos currentBlockPos, boolean abilityActive, boolean voiceActive) {
    public static void encode(OpenMenuMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId());
        buffer.m_130083_(msg.name);
        buffer.m_130068_((Enum)msg.alignment);
        buffer.writeBoolean(msg.followingPlayer);
        buffer.m_130064_(msg.currentBlockPos);
        buffer.writeBoolean(msg.abilityActive);
        buffer.writeBoolean(msg.voiceActive);
    }

    public static OpenMenuMessage decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        Component name = buffer.m_130238_();
        Alignment alignment = (Alignment)buffer.m_130066_(Alignment.class);
        boolean followingPlayer = buffer.readBoolean();
        BlockPos currentBlockPos = buffer.m_130135_();
        boolean abilityActive = buffer.readBoolean();
        boolean voiceActive = buffer.readBoolean();
        return new OpenMenuMessage(name, id, alignment, followingPlayer, currentBlockPos, abilityActive, voiceActive);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                OpenMenuMessageClientHandler.openMenu(this.name(), this.entityId(), this.alignment(), this.followingPlayer(), this.currentBlockPos(), this.abilityActive(), this.voiceActive());
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

