/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.network.AltarParticleMessage;
import com.saphienyako.feywild.network.DismissEntityMessage;
import com.saphienyako.feywild.network.OpenMenuMessage;
import com.saphienyako.feywild.network.ParticleMessage;
import com.saphienyako.feywild.network.ToggleAbilityMessage;
import com.saphienyako.feywild.network.ToggleFollowPlayerMessage;
import com.saphienyako.feywild.network.ToggleVoiceMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class FeywildNetwork {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("feywild", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(ParticleMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(ParticleMessage::decode).encoder(ParticleMessage::encode).consumerMainThread(ParticleMessage::handle).add();
        net.messageBuilder(AltarParticleMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(AltarParticleMessage::decode).encoder(AltarParticleMessage::encode).consumerMainThread(AltarParticleMessage::handle).add();
        net.messageBuilder(OpenMenuMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(OpenMenuMessage::decode).encoder(OpenMenuMessage::encode).consumerMainThread(OpenMenuMessage::handle).add();
        net.messageBuilder(ToggleFollowPlayerMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ToggleFollowPlayerMessage::decode).encoder(ToggleFollowPlayerMessage::encode).consumerMainThread(ToggleFollowPlayerMessage::handle).add();
        net.messageBuilder(ToggleAbilityMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ToggleAbilityMessage::decode).encoder(ToggleAbilityMessage::encode).consumerMainThread(ToggleAbilityMessage::handle).add();
        net.messageBuilder(ToggleVoiceMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ToggleVoiceMessage::decode).encoder(ToggleVoiceMessage::encode).consumerMainThread(ToggleVoiceMessage::handle).add();
        net.messageBuilder(DismissEntityMessage.class, FeywildNetwork.id(), NetworkDirection.PLAY_TO_SERVER).decoder(DismissEntityMessage::decode).encoder(DismissEntityMessage::encode).consumerMainThread(DismissEntityMessage::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static void sendParticles(Level level, ParticleMessage.Type type, BlockPos chunk) {
        if (level instanceof ServerLevel) {
            INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(chunk)), (Object)new ParticleMessage(type, chunk));
        }
    }

    public static void sendParticles(Level level, AltarParticleMessage.Type type, BlockPos chunk, int progress, int maxProgress) {
        if (level instanceof ServerLevel) {
            INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(chunk)), (Object)new AltarParticleMessage(type, chunk, progress, maxProgress));
        }
    }

    static {
        packetId = 0;
    }
}

