/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.base.PixieBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IronPanicGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final LivingEntity entity;
    private final double speed;
    private final double range;
    private Level level;

    public IronPanicGoal(PixieBase entity, Level level, double speed, double range) {
        this.entity = entity;
        this.level = level;
        this.speed = speed;
        this.range = range;
    }

    public boolean m_8036_() {
        List players = this.entity.m_9236_().m_6443_(Player.class, this.entity.m_20191_().m_82400_(this.range), player -> !player.m_7500_() && this.isHoldingIron((Player)player));
        return !players.isEmpty();
    }

    public void m_8056_() {
        Player targetPlayer = this.findPlayer();
        if (targetPlayer == null) {
            return;
        }
        Vec3 dir = this.entity.m_20182_().m_82546_(targetPlayer.m_20182_()).m_82541_();
        double intensity = 0.4;
        this.entity.m_20256_(dir.m_82490_(intensity));
        this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, targetPlayer.m_20182_());
    }

    private boolean isHoldingIron(Player player) {
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        return this.isIron(main) || this.isIron(off);
    }

    private boolean isIron(ItemStack stack) {
        return !stack.m_41619_() && stack.m_150930_(Items.f_42416_);
    }

    public boolean m_8045_() {
        return false;
    }

    @Nullable
    private Player findPlayer() {
        double distance = Double.MAX_VALUE;
        Player current = null;
        for (Player player : this.level.m_45971_(Player.class, TARGETING, this.entity, this.entity.m_20191_().m_82400_(8.0))) {
            if (player.m_7500_() || !this.isHoldingIron(player) || !(this.entity.m_20280_((Entity)player) < distance)) continue;
            current = player;
            distance = this.entity.m_20280_((Entity)player);
        }
        return current;
    }
}

