/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.goals.MovementRestrictionGoal;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class GoToTargetPositionGoal
extends MovementRestrictionGoal {
    private final Mob entity;
    private final int triggerRangeSquared;
    private final float speed;

    public GoToTargetPositionGoal(Mob entity, Supplier<Vec3> pos, int maxMovementRange, float speed) {
        super(pos, maxMovementRange);
        this.entity = entity;
        this.speed = speed;
        this.triggerRangeSquared = maxMovementRange * 2 * (maxMovementRange * 2);
    }

    public GoToTargetPositionGoal(Mob entity, Supplier<Vec3> pos, int maxMovementRange, float speed, Supplier<Boolean> shouldReturn) {
        super(pos, maxMovementRange);
        this.entity = entity;
        this.speed = speed;
        this.triggerRangeSquared = maxMovementRange * 2 * (maxMovementRange * 2);
    }

    public void m_8037_() {
        Vec3 target = (Vec3)this.targetPosition.get();
        if (target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.m_20182_(), target) > (double)this.triggerRangeSquared) {
            this.entity.m_6034_(target.f_82479_, target.f_82480_ + 1.0, target.f_82481_);
        } else if (target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.m_20182_(), target) > (double)this.maxMovementRangeSquared) {
            this.entity.m_21573_().m_26519_(target.f_82479_, target.f_82480_ + 1.0, target.f_82481_, (double)this.speed);
        }
    }

    public boolean m_8045_() {
        Vec3 target = (Vec3)this.targetPosition.get();
        return target != null && GoToTargetPositionGoal.distanceFromSquared(this.entity.m_20182_(), target) > (double)this.maxMovementRangeSquared / 2.0;
    }

    @Override
    public boolean m_8036_() {
        Vec3 target = (Vec3)this.targetPosition.get();
        return this.entity.m_9236_().f_46441_.m_188501_() < 0.25f && target != null && !this.isInRange(this.entity.m_20182_());
    }

    public static GoToTargetPositionGoal byBlockPos(Mob entity, Supplier<BlockPos> pos, int maxMovementRange, float speed) {
        return new GoToTargetPositionGoal(entity, GoToTargetPositionGoal.asVector(pos), maxMovementRange, speed);
    }

    public static GoToTargetPositionGoal byBlockPos(Mob entity, Supplier<BlockPos> pos, int maxMovementRange, float speed, Supplier<Boolean> shouldReturn) {
        return new GoToTargetPositionGoal(entity, GoToTargetPositionGoal.asVector(pos), maxMovementRange, speed, shouldReturn);
    }
}

