/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.base.PixieBase;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.ParticleMessage;
import com.saphienyako.feywild.sound.ModSounds;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class GatherMobItemsGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final PixieBase entity;
    private Level level;
    private int ticksLeft = 0;
    private Animal targetMob;

    public GatherMobItemsGoal(PixieBase entity, Level level) {
        this.entity = entity;
        this.level = level;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetMob == null || !this.targetMob.m_6084_() || this.targetMob.m_6162_()) {
                this.targetMob = this.findTarget();
                if (this.targetMob == null || !this.targetMob.m_6084_() || this.targetMob.m_6162_()) {
                    this.reset();
                    return;
                }
            }
            if (this.ticksLeft <= 0) {
                if (this.level instanceof ServerLevel) {
                    this.dropFromLootTable((Mob)this.targetMob);
                    this.entity.m_7327_((Entity)this.targetMob);
                    FeywildNetwork.sendParticles(this.level, ParticleMessage.Type.MOB_COLLECT, this.targetMob.m_20183_());
                    this.entity.m_5496_(SoundEvents.f_11763_, 0.7f, 1.0f);
                }
                this.reset();
            } else if (this.ticksLeft == 45) {
                this.spellCasting();
            } else if (this.ticksLeft <= 35) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetMob.m_20182_());
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 55;
        this.targetMob = null;
    }

    private void spellCasting() {
        this.entity.setState(PixieBase.State.SPELL_CASTING);
        this.entity.m_5496_((SoundEvent)ModSounds.PIXIE_SPELL_CASTING.get(), 0.7f, 1.0f);
    }

    protected void reset() {
        this.entity.setState(PixieBase.State.IDLE);
        this.targetMob = null;
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        Player owning = this.entity.getOwningPlayer();
        if (owning instanceof ServerPlayer && this.entity.getAbilityActive().booleanValue()) {
            return this.level.f_46441_.m_188501_() < 0.01f;
        }
        return false;
    }

    @Nullable
    private Animal findTarget() {
        double distance = Double.MAX_VALUE;
        Animal current = null;
        for (Animal mob : this.level.m_45971_(Animal.class, TARGETING, (LivingEntity)this.entity, this.entity.m_20191_().m_82400_(8.0))) {
            TamableAnimal tameable;
            AbstractHorse horse;
            if (mob instanceof AbstractHorse && (horse = (AbstractHorse)mob).m_30614_() || !mob.m_6084_() || mob.m_6162_() || mob instanceof TamableAnimal && (tameable = (TamableAnimal)mob).m_21824_() || !(this.entity.m_20280_((Entity)mob) < distance)) continue;
            current = mob;
            distance = this.entity.m_20280_((Entity)mob);
        }
        return current;
    }

    protected void dropFromLootTable(Mob mob) {
        DamageSource source = this.entity.m_9236_().m_269111_().m_269425_();
        ResourceLocation resourcelocation = mob.m_5743_();
        LootTable loottable = Objects.requireNonNull(mob.m_9236_().m_7654_()).m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)mob.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287289_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)source.m_7640_());
        LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287276_(lootparams, mob.m_287233_(), arg_0 -> ((PixieBase)this.entity).m_19983_(arg_0));
    }
}

