/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.base.PixieBase;
import com.saphienyako.feywild.sound.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BreedAbilityGoal
extends Goal {
    private static final TargetingConditions TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final PixieBase entity;
    private Animal targetAnimal;
    private Animal partner;
    private int ticksLeft = 0;
    private Level level;

    public BreedAbilityGoal(PixieBase entity, Level level) {
        this.entity = entity;
        this.level = level;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.m_6084_() || !this.partner.m_6084_()) {
                this.targetAnimal = this.findTarget();
                this.partner = this.findPartner();
                if (this.targetAnimal == null || this.partner == null || !this.targetAnimal.m_6084_() || !this.partner.m_6084_()) {
                    this.reset();
                    return;
                }
            }
            if (!this.targetAnimal.m_6084_() || !this.partner.m_6084_() || this.targetAnimal.m_146764_() != 0 || this.partner.m_146764_() != 0) {
                this.reset();
                return;
            }
            if (this.ticksLeft <= 0) {
                if (this.level instanceof ServerLevel) {
                    this.targetAnimal.m_27563_((ServerLevel)this.level, this.partner);
                }
                this.reset();
            } else if (this.ticksLeft == 45) {
                this.spellCasting();
            } else if (this.ticksLeft <= 35) {
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetAnimal.m_20182_());
                this.entity.m_21573_().m_5624_((Entity)this.targetAnimal, 0.5);
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 55;
        this.targetAnimal = null;
        this.partner = null;
    }

    private void spellCasting() {
        this.entity.setState(PixieBase.State.SPELL_CASTING);
        this.entity.m_5496_((SoundEvent)ModSounds.PIXIE_SPELL_CASTING.get(), 0.7f, 1.0f);
    }

    protected void reset() {
        this.entity.setState(PixieBase.State.IDLE);
        this.targetAnimal = null;
        this.partner = null;
        this.ticksLeft = -1;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        Player owning = this.entity.getOwningPlayer();
        if (owning instanceof ServerPlayer && this.entity.getAbilityActive().booleanValue()) {
            return this.level.f_46441_.m_188501_() < 0.02f;
        }
        return false;
    }

    @Nullable
    private Animal findTarget() {
        double distance = Double.MAX_VALUE;
        Animal current = null;
        for (Animal animal : this.level.m_45971_(Animal.class, TARGETING, (LivingEntity)this.entity, this.entity.m_20191_().m_82400_(8.0))) {
            if (animal.m_146764_() != 0 || !(this.entity.m_20280_((Entity)animal) < distance)) continue;
            current = animal;
            distance = this.entity.m_20280_((Entity)animal);
        }
        return current;
    }

    @Nullable
    private Animal findPartner() {
        if (this.targetAnimal != null) {
            double distance = Double.MAX_VALUE;
            Animal current = null;
            for (Animal animal : this.level.m_45971_(Animal.class, TARGETING, (LivingEntity)this.targetAnimal, this.targetAnimal.m_20191_().m_82400_(8.0))) {
                if (animal.m_146764_() != 0) continue;
                int oldInLove1 = this.targetAnimal.m_27591_();
                int oldInLove2 = animal.m_27591_();
                this.targetAnimal.m_27601_(1);
                animal.m_27601_(1);
                if (this.targetAnimal.m_7848_(animal) && this.targetAnimal.m_20280_((Entity)animal) < distance) {
                    current = animal;
                    distance = this.targetAnimal.m_20280_((Entity)animal);
                }
                this.targetAnimal.m_27601_(oldInLove1);
                animal.m_27601_(oldInLove2);
            }
            return current;
        }
        return null;
    }
}

