/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.base;

import com.saphienyako.feywild.entity.Alignment;
import com.saphienyako.feywild.entity.base.intereface.IOwnable;
import com.saphienyako.feywild.entity.base.intereface.ISummonable;
import com.saphienyako.feywild.entity.goals.GoToTargetPositionGoal;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class FeyBase
extends PathfinderMob
implements IOwnable,
ISummonable {
    @javax.annotation.Nullable
    protected UUID owner;
    @javax.annotation.Nullable
    private BlockPos summonPos = null;
    private boolean followingPlayer = false;
    private boolean abilityActive = false;
    private boolean voiceActive = true;

    protected FeyBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22280_, Attributes.f_22280_.m_22082_()).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22286_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public static boolean canSpawn(EntityType<? extends FeyBase> entity, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return FeyBase.isBrightEnoughToSpawn((BlockAndTintGetter)level, pos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter getter, BlockPos pos) {
        return getter.m_45524_(pos, 0) > 8;
    }

    @javax.annotation.Nullable
    public SimpleParticleType getParticle() {
        return null;
    }

    @javax.annotation.Nullable
    public Vec3 getCurrentPointOfInterest() {
        if (this.getFollowingPlayer().booleanValue()) {
            Player player = this.getOwningPlayer();
            return player == null ? null : player.m_20182_();
        }
        if (this.summonPos != null) {
            return new Vec3((double)this.summonPos.m_123341_() + 0.5, (double)this.summonPos.m_123342_(), (double)this.summonPos.m_123343_() + 0.5);
        }
        return null;
    }

    public float getTargetPositionSpeed() {
        return 1.5f;
    }

    @OverridingMethodsMustInvokeSuper
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(30, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(11, (Goal)new GoToTargetPositionGoal((Mob)this, this::getCurrentPointOfInterest, 6, this.getTargetPositionSpeed()));
        this.f_21345_.m_25352_(30, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.getParticle() != null && this.f_19796_.m_188503_(11) == 0) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)this.getParticle(), this.m_20185_() + (Math.random() - 0.5), this.m_20186_() + 1.0 + (Math.random() - 0.5), this.m_20189_() + (Math.random() - 0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.owner != null) {
            nbt.m_128362_("Owner", this.owner);
        } else {
            nbt.m_128473_("Owner");
        }
        if (this.summonPos != null) {
            nbt.m_128365_("SummonPos", (Tag)NbtUtils.m_129224_((BlockPos)this.summonPos));
        } else {
            nbt.m_128473_("SummonPos");
        }
        nbt.m_128379_("FollowingPlayer", this.followingPlayer);
        nbt.m_128379_("AbilityActive", this.abilityActive);
        nbt.m_128379_("VoiceActive", this.voiceActive);
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.owner = nbt.m_128403_("Owner") ? nbt.m_128342_("Owner") : null;
        this.summonPos = nbt.m_128425_("SummonPos", 10) ? NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("SummonPos")).m_7949_() : null;
        this.followingPlayer = nbt.m_128471_("FollowingPlayer");
        this.abilityActive = nbt.m_128471_("AbilityActive");
        this.voiceActive = nbt.m_128471_("VoiceActive");
    }

    public boolean m_21275_(DamageSource damageSource) {
        LivingEntity living;
        ItemStack held;
        Entity attacker = damageSource.m_7639_();
        if (attacker instanceof LivingEntity && !this.isIronTool(held = (living = (LivingEntity)attacker).m_21205_())) {
            return true;
        }
        return super.m_21275_(damageSource);
    }

    private boolean isIronTool(ItemStack stack) {
        TieredItem tiered;
        Item item;
        return stack.m_204117_(Tags.Items.TOOLS) && (item = stack.m_41720_()) instanceof TieredItem && (tiered = (TieredItem)item).m_43314_() == Tiers.IRON;
    }

    @Override
    @javax.annotation.Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@javax.annotation.Nullable UUID uid) {
        this.owner = uid;
    }

    @Override
    @Nullable
    public BlockPos getSummonPos() {
        return this.summonPos;
    }

    @Override
    public void setSummonPos(BlockPos pos) {
        this.summonPos = pos == null ? null : pos.m_7949_();
    }

    public void setFollowingPlayer(Boolean followingPlayer) {
        this.followingPlayer = followingPlayer;
    }

    public Boolean getFollowingPlayer() {
        return this.followingPlayer;
    }

    public Boolean getAbilityActive() {
        return this.abilityActive;
    }

    public void setAbilityActive(Boolean abilityActive) {
        this.abilityActive = abilityActive;
    }

    public Boolean getVoiceActive() {
        return this.voiceActive;
    }

    public void setVoiceActive(Boolean voiceActive) {
        this.voiceActive = voiceActive;
    }

    @Override
    public Level getEntityLevel() {
        return this.m_9236_();
    }

    public boolean m_6147_() {
        return false;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public boolean m_142535_(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    public int m_213860_() {
        return this.isTamed() ? 0 : super.m_213860_();
    }

    public boolean m_6573_(@Nonnull Player player) {
        return false;
    }

    protected boolean m_7341_(@Nonnull Entity entityIn) {
        return false;
    }

    public float m_6100_() {
        return 1.0f;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_6785_(double distanceSq) {
        return false;
    }

    public abstract SoundEvent getCookieSound();

    public abstract SoundEvent getNameSound();

    public abstract SoundEvent getSummonSound();

    public abstract SoundEvent getDismissSound();

    public abstract SoundEvent getFollowSound();

    public abstract SoundEvent getStaySound();

    public abstract SoundEvent getAbilityOnSound();

    public abstract SoundEvent getAbilityOffSound();

    public abstract Alignment getAlignment();

    public abstract ItemLike getDismissItem();

    public String getEntityName() {
        ResourceLocation id = this.m_6095_().m_204041_().m_205785_().m_135782_();
        return id.m_135815_();
    }

    public Component getFeyNameMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_name"));
    }

    public Component getFeyCookieMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_cookie"));
    }

    public Component getFeyFollowMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_follow"));
    }

    public Component getFeyStayMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_stay"));
    }

    public Component getFeySummonMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_summon"));
    }

    public Component getFeyDismissMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_dismiss"));
    }

    public Component getFeyAbilityOnMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_ability_on"));
    }

    public Component getFeyAbilityOffMessage() {
        return Component.m_237115_((String)("message.feywild." + this.getEntityName() + "_ability_off"));
    }
}

