/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.block.entity;

import com.saphienyako.feywild.block.entity.ModBlockEntities;
import com.saphienyako.feywild.network.AltarParticleMessage;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.recipe.FeyAltarRecipe;
import com.saphienyako.feywild.screen.FeyAltarMenu;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeyAltarBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot == 5) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private static final int INPUT_SLOT_00 = 0;
    private static final int INPUT_SLOT_01 = 1;
    private static final int INPUT_SLOT_02 = 2;
    private static final int INPUT_SLOT_03 = 3;
    private static final int INPUT_SLOT_04 = 4;
    private static final int OUTPUT_SLOT = 5;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> FeyAltarBlockEntity.this.progress;
                case 1 -> FeyAltarBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    FeyAltarBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    FeyAltarBlockEntity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 40;

    public FeyAltarBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FEY_ALTAR_BLOCK_ENTITY.get(), pos, blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.itemHandler;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("progress", this.progress);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("progress");
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.feywild.fey_altar");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new FeyAltarMenu(id, inventory, this, this.data);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.hasRecipe()) {
                this.increaseCraftingProgress();
                this.m_6596_();
                level.m_7260_(this.f_58858_, state, state, 2);
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress();
                    this.m_6596_();
                    level.m_7260_(this.f_58858_, state, state, 2);
                }
            } else {
                this.resetProgress();
                this.m_6596_();
                level.m_7260_(this.f_58858_, state, state, 2);
            }
            this.addParticles();
        }
    }

    private void addParticles() {
        if (this.progress > 0) {
            if (this.progress >= this.maxProgress - 1) {
                FeywildNetwork.sendParticles(this.f_58857_, AltarParticleMessage.Type.ALTAR_01, this.f_58858_, this.progress, this.maxProgress);
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
                    ItemStack stack = this.itemHandler.getStackInSlot(slot);
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                if (!stacks.isEmpty()) {
                    FeywildNetwork.sendParticles(this.f_58857_, AltarParticleMessage.Type.ALTAR_02, this.f_58858_, this.progress, this.maxProgress);
                }
            }
        } else {
            FeywildNetwork.sendParticles(this.f_58857_, AltarParticleMessage.Type.ALTAR_03, this.f_58858_, this.progress, this.maxProgress);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasRecipe() {
        Optional<FeyAltarRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_());
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<FeyAltarRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        return this.f_58857_.m_7465_().m_44015_((RecipeType)FeyAltarRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private void craftItem() {
        Optional<FeyAltarRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.extractItem(3, 1, false);
        this.itemHandler.extractItem(4, 1, false);
        this.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(5).m_41613_() + result.m_41613_()));
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(5).m_41619_() || this.itemHandler.getStackInSlot(5).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(5).m_41613_() + count <= this.itemHandler.getStackInSlot(5).m_41741_();
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, te -> nbt);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }
}

