/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.block;

import com.saphienyako.feywild.config.ModConfig;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GiantFlowerBlock
extends Block {
    public static final VoxelShape STEM_SHAPE = GiantFlowerBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape FLOWER_SHAPE = GiantFlowerBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final IntegerProperty PART = IntegerProperty.m_61631_((String)"part", (int)0, (int)3);
    public final int height;

    public GiantFlowerBlock(int height) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50360_).m_60955_().m_60918_(SoundType.f_56754_).m_60913_(1.0f, 1.0f).m_60953_(value -> 8).m_278166_(PushReaction.DESTROY));
        this.height = height;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PART, (Comparable)Integer.valueOf(3)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PART});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return (Integer)state.m_61143_((Property)PART) == 3 ? FLOWER_SHAPE : STEM_SHAPE;
    }

    @Nonnull
    public VoxelShape m_5909_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return (Integer)state.m_61143_((Property)PART) == 1 || (Integer)state.m_61143_((Property)PART) == 3 ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public void m_6810_(@Nonnull BlockState oldState, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            this.removeOthers(level, oldState, pos);
        }
        super.m_6810_(oldState, level, pos, newState, moving);
    }

    public boolean m_6724_(@Nonnull BlockState state) {
        return (Integer)state.m_61143_((Property)PART) == 3;
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if ((Integer)state.m_61143_((Property)PART) == 3) {
            this.tickFlower(state, level, pos, random);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if ((Integer)state.m_61143_((Property)PART) == 3 && ((Boolean)ModConfig.CLIENT.flower_particles.get()).booleanValue()) {
            this.animateFlower(state, level, pos, random);
        }
    }

    protected abstract void tickFlower(BlockState var1, ServerLevel var2, BlockPos var3, RandomSource var4);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void animateFlower(BlockState var1, Level var2, BlockPos var3, RandomSource var4);

    public abstract BlockState flowerState(LevelAccessor var1, BlockPos var2, RandomSource var3);

    protected void removeOthers(Level level, BlockState state, BlockPos pos) {
        BlockPos target;
        int i;
        int blocksBelow = (Integer)state.m_61143_((Property)PART) - (4 - this.height);
        int blocksAbove = 3 - (Integer)state.m_61143_((Property)PART);
        for (i = 1; i <= blocksBelow; ++i) {
            target = pos.m_7918_(0, -i, 0);
            if (level.m_8055_(target).m_60734_() != this) continue;
            level.m_7731_(target, Blocks.f_50016_.m_49966_(), 2);
        }
        for (i = 1; i <= blocksAbove; ++i) {
            target = pos.m_7918_(0, i, 0);
            if (level.m_8055_(target).m_60734_() != this) continue;
            level.m_7731_(target, Blocks.f_50016_.m_49966_(), 2);
        }
    }
}

