/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourcelinkEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ArcanePedestalTile;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SourcelinkTile
extends AbstractSourceMachine
implements GeoBlockEntity,
ITickable {
    int progress;
    public boolean isDisabled = false;
    public boolean registered = false;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SourcelinkTile(BlockEntityType<?> sourceLinkTile, BlockPos pos, BlockState state) {
        super(sourceLinkTile, pos, state);
    }

    public SourcelinkTile(RegistryWrapper<? extends BlockEntityType<?>> sourceLinkTile, BlockPos pos, BlockState state) {
        super(sourceLinkTile.get(), pos, state);
    }

    @Override
    public int getTransferRate() {
        return 1000;
    }

    @Override
    public int getMaxSource() {
        return 1000;
    }

    @Override
    public void tick() {
        List<ISpecialSourceProvider> providers;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.f_58857_.m_46467_() % 120L == 0L && this.usesEventQueue()) {
            SourcelinkEventQueue.addPosition(this.f_58857_, this.f_58858_);
            this.registered = true;
        }
        if (this.f_58857_.m_46467_() % 100L == 0L && this.getSource() > 0 && !(providers = SourceUtil.canGiveSource(this.f_58858_, this.f_58857_, 5)).isEmpty()) {
            this.transferSource(this, providers.get(0).getSource());
            ParticleUtil.spawnFollowProjectile(this.f_58857_, this.f_58858_, providers.get(0).getCurrentPos(), this.getColor());
        }
    }

    public List<ArcanePedestalTile> getSurroundingPedestals() {
        ArrayList<ArcanePedestalTile> inventories = new ArrayList<ArcanePedestalTile>();
        for (BlockPos p : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7495_().m_122029_().m_122012_(), (BlockPos)this.m_58899_().m_7494_().m_122024_().m_122019_())) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(p);
            if (!(blockEntity instanceof ArcanePedestalTile)) continue;
            ArcanePedestalTile pedestal = (ArcanePedestalTile)blockEntity;
            inventories.add(pedestal);
        }
        return inventories;
    }

    public void getManaEvent(BlockPos sourcePos, int total) {
        this.addSource(total);
        ParticleUtil.spawnFollowProjectile(this.f_58857_, sourcePos, this.f_58858_, this.getColor());
    }

    public boolean eventInRange(BlockPos sourcePos, @Nullable Event event) {
        return BlockUtil.distanceFrom(this.f_58858_, sourcePos) <= 15.0;
    }

    public boolean usesEventQueue() {
        return false;
    }

    public void doRandomAction() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        this.isDisabled = tag.m_128471_("disabled");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("disabled", this.isDisabled);
    }

    private <E extends BlockEntity> PlayState idlePredicate(AnimationState<E> event) {
        if (this.isDisabled) {
            return PlayState.STOP;
        }
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        return PlayState.CONTINUE;
    }
}

