/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ManaUtil {
    static final UUID MAX_MANA_MODIFIER = UUID.fromString("6662fdb1-bc67-49bc-9bba-8e306bbc1ae6");
    static final UUID MANA_REGEN_MODIFIER = UUID.fromString("3bd42486-6a51-44c4-a88f-04021af5df03");

    public static int getPlayerDiscounts(LivingEntity e, Spell spell, ItemStack casterStack) {
        if (e == null) {
            return 0;
        }
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack item = items.getStackInSlot(i);
                Item patt1325$temp = item.m_41720_();
                if (!(patt1325$temp instanceof IManaDiscountEquipment)) continue;
                IManaDiscountEquipment discountItem = (IManaDiscountEquipment)patt1325$temp;
                discounts.addAndGet(discountItem.getManaDiscount(item, spell));
            }
        });
        for (ItemStack armor : e.m_6168_()) {
            Item item = armor.m_41720_();
            if (!(item instanceof IManaDiscountEquipment)) continue;
            IManaDiscountEquipment discountItem = (IManaDiscountEquipment)item;
            discounts.addAndGet(discountItem.getManaDiscount(armor, spell));
        }
        Item item = casterStack.m_41720_();
        if (item instanceof IManaDiscountEquipment) {
            IManaDiscountEquipment discountEquipment = (IManaDiscountEquipment)item;
            discounts.addAndGet(discountEquipment.getManaDiscount(casterStack, spell));
        }
        return discounts.get();
    }

    public static double getCurrentMana(LivingEntity e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana(e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        return mana.getCurrentMana();
    }

    public static Mana calcMaxMana(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return new Mana(0, 0.0f);
        }
        double rawMax = 0.0;
        int tier = mana.getBookTier();
        int numGlyphs = mana.getGlyphBonus();
        rawMax += (double)((Integer)ServerConfig.INIT_MAX_MANA.get()).intValue();
        rawMax += (double)(numGlyphs * (Integer)ServerConfig.GLYPH_MAX_BONUS.get());
        rawMax += (double)(tier * (Integer)ServerConfig.TIER_MAX_BONUS.get());
        AttributeInstance manaAttribute = e.m_21051_((Attribute)PerkAttributes.MAX_MANA.get());
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.m_22111_(MAX_MANA_MODIFIER);
            if (manaCache == null || manaCache.m_22218_() != rawMax) {
                if (manaCache != null) {
                    manaAttribute.m_22130_(manaCache);
                }
                manaAttribute.m_22118_(new AttributeModifier(MAX_MANA_MODIFIER, "Mana Cache", rawMax, AttributeModifier.Operation.ADDITION));
            }
            rawMax = manaAttribute.m_22135_();
        }
        int max = (int)rawMax;
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max);
        MinecraftForge.EVENT_BUS.post((Event)event);
        max = event.getMax();
        float reserve = event.getReserve();
        return new Mana(max, reserve);
    }

    public static int getMaxMana(Player e) {
        return ManaUtil.calcMaxMana(e).getRealMax();
    }

    public static double getManaRegen(Player e) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)e).orElse(null);
        if (mana == null) {
            return 0.0;
        }
        double regen = 0.0;
        int tier = mana.getBookTier();
        double numGlyphs = mana.getGlyphBonus();
        regen += numGlyphs * (Double)ServerConfig.GLYPH_REGEN_BONUS.get();
        regen += (double)(tier * (Integer)ServerConfig.TIER_REGEN_BONUS.get());
        regen += (double)((Integer)ServerConfig.INIT_MANA_REGEN.get()).intValue();
        AttributeInstance manaAttribute = e.m_21051_((Attribute)PerkAttributes.MANA_REGEN_BONUS.get());
        if (manaAttribute != null) {
            AttributeModifier manaCache = manaAttribute.m_22111_(MANA_REGEN_MODIFIER);
            if (manaCache == null || manaCache.m_22218_() != regen) {
                if (manaCache != null) {
                    manaAttribute.m_22130_(manaCache);
                }
                manaAttribute.m_22118_(new AttributeModifier(MANA_REGEN_MODIFIER, "Mana Regen Cache", regen, AttributeModifier.Operation.ADDITION));
            }
            regen = manaAttribute.m_22135_();
        }
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen);
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen = event.getRegen();
        return regen;
    }

    public record Mana(int Max, float Reserve) {
        public int getRealMax() {
            return (int)((double)this.Max * (1.0 - (double)this.Reserve));
        }
    }
}

