/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor;

import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.bush.WhitePuffballBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;

class BWGProcessorRules {
    protected static final ProcessorRule[] FORGOTTEN_ROCKY_STONE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, BWGBlocks.MOSSY_STONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, Blocks.f_49994_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.ROCKY_STONE_SET.getBase(), 0.25f, Blocks.f_50069_)};
    protected static final ProcessorRule FORGOTTEN_GRAVEL = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_49994_, 0.35f, Blocks.f_276445_);
    protected static final ProcessorRule FORGOTTEN_LUSH_GRASS_BLOCK = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), 0.45f, Blocks.f_152544_);
    protected static final ProcessorRule[] FORGOTTEN_MOSSY_STONE_BRICKS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50223_, 0.1f, Blocks.f_50222_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50223_, 0.2f, Blocks.f_50224_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50223_, 0.1f, Blocks.f_152496_)};
    protected static final ProcessorRule[] DIRT_RANDOM_GRASS_COARSE_DIRT_PODZOL = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50493_, 0.25f, Blocks.f_50440_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50493_, 0.25f, Blocks.f_50546_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50493_, 0.25f, Blocks.f_50599_)};
    protected static final ProcessorRule[] GRASS_RANDOM_DIRT_PODZOL_COARSE_DIRT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50440_, 0.25f, Blocks.f_50493_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50440_, 0.25f, Blocks.f_50599_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50440_, 0.25f, Blocks.f_50546_)};
    protected static final ProcessorRule[] STONE_RANDOM_COBBLESTONE_MOSSY = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.15f, Blocks.f_50652_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.15f, Blocks.f_50079_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.15f, BWGBlocks.MOSSY_STONE_SET.getBase())};
    protected static final ProcessorRule[] MOSSIFY_70_PERCENT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.7f, BWGBlocks.MOSSY_STONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50652_, 0.7f, Blocks.f_50079_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50222_, 0.7f, Blocks.f_50223_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50635_, 0.7f, (Block)BWGBlocks.MOSSY_STONE_SET.getStairs()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50157_, 0.7f, Blocks.f_50633_)};
    protected static final ProcessorRule[] SWEETBERRY_BLUEBERRY_50_PERCENT_RANDOM_AGE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50685_, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(0))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50685_, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50685_, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(2))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50685_, 0.125f, (BlockState)BWGBlocks.BLUEBERRY_BUSH.get().m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(3))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(0))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(2))), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.BLUEBERRY_BUSH.get(), 0.125f, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(3)))};
    protected static final ProcessorRule MOSSIFY_10_PERCENT = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50652_, 0.1f, Blocks.f_50079_);
    protected static final ProcessorRule[] WHITE_PUFFBALL_RANDOM_AGE = BWGProcessorRules.createEvenChanceAgeRules(BWGBlocks.WHITE_PUFFBALL.getBlock(), WhitePuffballBlock.f_57244_, 3);
    protected static final ProcessorRule[] PUMPKIN_RANDOM_AGE = BWGProcessorRules.createEvenChanceAgeRules(Blocks.f_50189_, StemBlock.f_57013_, 7);
    protected static final ProcessorRule STRIPPED_DARK_OAK_WOOD_35_PERCENT_DARK_OAK_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50745_, 0.35f, Blocks.f_50049_);
    protected static final ProcessorRule STRIPPED_OAK_LOG_60_PERCENT_OAK_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50010_, 0.6f, Blocks.f_50705_);
    protected static final ProcessorRule[] POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50387_, 0.3f, Blocks.f_50334_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50387_, 0.3f, Blocks.f_49994_)};
    protected static final ProcessorRule[] STONE_SLAB_RANDOM_ANDESITE_ROCKY_SLAB = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50404_, 0.33f, (BlockState)Blocks.f_50600_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50404_, 0.33f, (BlockState)BWGBlocks.ROCKY_STONE_SET.getSlab().m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM))};
    protected static final ProcessorRule[] STONE_SLAB_RANDOM_ANDESITE_COBBLE_SLAB = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50404_, 0.33f, (BlockState)Blocks.f_50600_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50404_, 0.33f, (BlockState)Blocks.f_50409_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM))};
    protected static final ProcessorRule[] LUSH_DIRT_PATH_PEAT_COARSE_DIRT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), 0.2f, BWGBlocks.PEAT.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), 0.2f, Blocks.f_50546_)};
    protected static final ProcessorRule[] FARM_TAIGA = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50092_, 0.3f, Blocks.f_50189_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50092_, 0.2f, Blocks.f_50250_)};
    protected static final ProcessorRule[] POTATO = BWGProcessorRules.createEvenChanceAgeRules(Blocks.f_50250_, PotatoBlock.f_52244_, 7);
    protected static final ProcessorRule[] CARROT = BWGProcessorRules.createEvenChanceAgeRules(Blocks.f_50249_, CarrotBlock.f_52244_, 7);
    protected static final ProcessorRule[] BEETROOT = BWGProcessorRules.createEvenChanceAgeRules(Blocks.f_50444_, BeetrootBlock.f_49657_, 3);
    protected static final ProcessorRule[] WHEAT = BWGProcessorRules.createEvenChanceAgeRules(Blocks.f_50092_, CropBlock.f_52244_, 7);
    protected static final ProcessorRule[] STONE_RANDOM_ROCKY_ANDESITE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.33f, Blocks.f_50334_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50069_, 0.33f, BWGBlocks.ROCKY_STONE_SET.getBase())};
    protected static final ProcessorRule[] ORANGE_TERRACOTTA_TO_RED_ROCK_CRACKED_RED_ROCK_BRICKS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50288_, 0.33f, BWGBlocks.RED_ROCK_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50288_, 0.33f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50288_, 0.1f, BWGBlocks.RED_ROCK_BRICKS_SET.getBase())};
    protected static final ProcessorRule RED_ROCK_BRICKS_TO_ORANGE_TERRACOTTA = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_BRICKS_SET.getBase(), 0.33f, Blocks.f_50288_);
    protected static final ProcessorRule RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase(), 0.5f, BWGBlocks.MOSSY_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule[] RED_ROCK_25_PERCENT_SPLIT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.3f, Blocks.f_50352_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.3f, Blocks.f_50288_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.3f, Blocks.f_49993_)};
    protected static final ProcessorRule STRIPPED_BAOBAB_WOOD_50_PERCENT_BAOBAB_PLANKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.BAOBAB.strippedWood(), 0.5f, BWGWood.BAOBAB.planks());
    protected static final ProcessorRule RED_ROCK_25_PERCENT_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.25f, BWGBlocks.RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule RED_ROCK_25_PERCENT_CRACKED_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_SET.getBase(), 0.25f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule RED_ROCK_BRICKS_35_PERCENT_CRACKED_RED_ROCK_BRICKS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.RED_ROCK_BRICKS_SET.getBase(), 0.35f, BWGBlocks.CRACKED_RED_ROCK_BRICKS_SET.getBase());
    protected static final ProcessorRule[] RANDOM_DESERT_POTTED_PLANT = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50248_, 0.1f, Blocks.f_50247_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50248_, 0.2f, BWGBlocks.PRICKLY_PEAR_CACTUS.getPottedBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50248_, 0.2f, BWGBlocks.MINI_CACTUS.getPottedBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50248_, 0.2f, BWGBlocks.GOLDEN_SPINED_CACTUS.getPottedBlock())};
    protected static final ProcessorRule WHITE_DACITE_10_PERCENT_COBBLED_WHITE_DACITE = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.WHITE_DACITE_COBBLESTONE_SET.getBase());
    protected static final ProcessorRule[] WHITE_DACITE_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.3f, BWGBlocks.WHITE_DACITE_COBBLESTONE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.3f, BWGBlocks.WHITE_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.CRACKED_WHITE_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.WHITE_DACITE_SET.getBase(), 0.1f, BWGBlocks.MOSSY_WHITE_DACITE_BRICKS_SET.getBase())};
    protected static final ProcessorRule[] DACITE_COBBLESTONE_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.DACITE_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.25f, BWGBlocks.DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.CRACKED_DACITE_BRICKS_SET.getBase()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(BWGBlocks.DACITE_COBBLESTONE_SET.getBase(), 0.1f, BWGBlocks.MOSSY_DACITE_BRICKS_SET.getBase())};
    protected static final ProcessorRule[] SHORT_GRASS_TO_FLOWER_PUMPKIN_PATCH = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.15f, (Block)BWGBlocks.LEAF_PILE.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.15f, (Block)BWGBlocks.CLOVER_PATCH.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.1f, BWGBlocks.WHITE_ANEMONE.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.1f, BWGBlocks.CROCUS.getBlock())};
    protected static final ProcessorRule[] SHORT_GRASS_TO_FLOWER_SWAMP = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.35f, Blocks.f_50016_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.15f, BWGBlocks.PEACH_LEATHER_FLOWER.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.15f, (Block)BWGBlocks.CLOVER_PATCH.get()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.1f, BWGBlocks.VIOLET_LEATHER_FLOWER.getBlock()), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50034_, 0.1f, Blocks.f_152543_)};
    protected static final ProcessorRule[] STONEBRICKS_VARIANTS = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50222_, 0.3f, Blocks.f_50223_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50222_, 0.3f, Blocks.f_50224_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50222_, 0.3f, BWGBlocks.MOSSY_STONE_SET.getBase())};
    protected static final ProcessorRule PODZOL_25_PERCENT_COARSE_DIRT = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50599_, 0.25f, Blocks.f_50546_);
    protected static final ProcessorRule PODZOL_10_PERCENT_GRAVEL = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50599_, 0.1f, Blocks.f_49994_);
    protected static final ProcessorRule[] PODZOL_10_PERCENT_ANDESITE = new ProcessorRule[]{BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50599_, 0.1f, Blocks.f_50334_), BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50599_, 0.1f, Blocks.f_50387_)};
    protected static final ProcessorRule PODZOL_50_PERCENT_LUSH_GRASS = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50599_, 0.5f, (Block)BWGBlocks.LUSH_GRASS_BLOCK.get());

    BWGProcessorRules() {
    }

    protected static ProcessorRule[] createEvenChanceAgeRules(Block block, IntegerProperty ageProperty, int maxAge) {
        ProcessorRule[] rules = new ProcessorRule[maxAge - 1];
        for (int i = 1; i <= maxAge - 1; ++i) {
            float chance = 1.0f / (float)(maxAge - i + 1);
            rules[i - 1] = BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(block, chance, (BlockState)block.m_49966_().m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(i)));
        }
        return rules;
    }

    protected static ProcessorRule burrowToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.PUMPKIN_BURROW.get(), chance, newBlock);
    }

    protected static ProcessorRule lushPathToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), chance, newBlock);
    }

    protected static ProcessorRule lushGrassToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), chance, newBlock);
    }

    protected static ProcessorRule tuffToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_152496_, chance, newBlock);
    }

    protected static ProcessorRule tuffToBlockState(float chance, BlockState newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_152496_, chance, newBlock);
    }

    protected static ProcessorRule grassBlockToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50440_, chance, newBlock);
    }

    protected static ProcessorRule chestToBlock(float chance, Block newBlock) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50087_, chance, newBlock);
    }

    protected static ProcessorRule lushDirtToCoarseDirt(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_DIRT_PATH.get(), chance, Blocks.f_50546_);
    }

    protected static ProcessorRule lushFarmLandToBlock(Block block, float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGBlocks.LUSH_FARMLAND.get(), chance, block);
    }

    protected static ProcessorRule streetWater(Block path, Block waterReplacement) {
        return new ProcessorRule((RuleTest)new BlockMatchTest(path), (RuleTest)new BlockMatchTest(Blocks.f_49990_), waterReplacement.m_49966_());
    }

    protected static ProcessorRule skyrisLeavesToGreenAppleLeaves(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.SKYRIS.leaves(), chance, (Block)BWGWood.SKYRIS_LEAVES_GREEN_APPLE.get());
    }

    protected static ProcessorRule skyrisLeavesToFlowering(float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest((Block)BWGWood.SKYRIS.leaves(), chance, (Block)BWGWood.FLOWERING_SKYRIS_LEAVES.get());
    }

    protected static ProcessorRule airToBlock(Block block, float chance) {
        return BWGProcessorRules.createAlwaysTrueRandomBlockMatchTest(Blocks.f_50016_, chance, block);
    }

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, Block newBlock) {
        return BWGProcessorRules.createProcessorRule((RuleTest)BWGProcessorRules.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.f_73954_, newBlock.m_49966_());
    }

    private static ProcessorRule createAlwaysTrueRandomBlockMatchTest(Block start, float chance, BlockState newBlock) {
        return BWGProcessorRules.createProcessorRule((RuleTest)BWGProcessorRules.createRandomBlockMatchTest(start, chance), AlwaysTrueTest.f_73954_, newBlock);
    }

    private static ProcessorRule createAlwaysTrueBlockMatchTest(Block start, BlockState newBlock) {
        return BWGProcessorRules.createProcessorRule((RuleTest)BWGProcessorRules.createBlockMatchTest(start), AlwaysTrueTest.f_73954_, newBlock);
    }

    private static BlockMatchTest createBlockMatchTest(Block start) {
        return new BlockMatchTest(start);
    }

    private static RandomBlockMatchTest createRandomBlockMatchTest(Block block, float chance) {
        return new RandomBlockMatchTest(block, chance);
    }

    private static ProcessorRule createProcessorRule(RuleTest test, AlwaysTrueTest alwaysTrueTest, BlockState blockState) {
        return new ProcessorRule(test, (RuleTest)alwaysTrueTest, blockState);
    }
}

