/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.recipe;

import com.benbenlaw.strainers.recipe.NoInventoryRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SummoningRecipe
implements Recipe<NoInventoryRecipe> {
    private final ResourceLocation id;
    private final String blockBelow;
    private final String fluidBelow;
    private final NonNullList<Ingredient> inputItem;
    private final String summonedMob;

    public SummoningRecipe(ResourceLocation id, String blockBelow, String fluidBelow, NonNullList<Ingredient> inputItem, String summonedMob) {
        this.id = id;
        this.blockBelow = blockBelow;
        this.fluidBelow = fluidBelow;
        this.inputItem = inputItem;
        this.summonedMob = summonedMob;
    }

    public String getBlockBelow() {
        return this.blockBelow;
    }

    public String getFluidBelow() {
        return this.fluidBelow;
    }

    public String getSummonedMob() {
        return this.summonedMob;
    }

    public NonNullList<Ingredient> getInputItem() {
        return this.inputItem;
    }

    public boolean matches(NoInventoryRecipe p_44002_, Level level) {
        return !level.m_5776_();
    }

    public ItemStack assemble(NoInventoryRecipe p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SummoningRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("strainers", "summoning");

        public SummoningRecipe fromJson(ResourceLocation id, JsonObject json) {
            String blockBelow = GsonHelper.m_13851_((JsonObject)json, (String)"blockBelow", (String)"");
            String fluidBelow = GsonHelper.m_13851_((JsonObject)json, (String)"fluidBelow", (String)"");
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            String summonedMob = GsonHelper.m_13906_((JsonObject)json, (String)"summonedMob");
            return new SummoningRecipe(id, blockBelow, fluidBelow, (NonNullList<Ingredient>)inputs, summonedMob);
        }

        @Nullable
        public SummoningRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String blockBelow = buf.m_130277_();
            String fluidBelow = buf.m_130277_();
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            String summonedMob = buf.m_130277_();
            return new SummoningRecipe(id, blockBelow, fluidBelow, (NonNullList<Ingredient>)inputs, summonedMob);
        }

        public void toNetwork(FriendlyByteBuf buf, SummoningRecipe recipe) {
            buf.m_130072_(recipe.getBlockBelow(), Short.MAX_VALUE);
            buf.m_130072_(recipe.getFluidBelow(), Short.MAX_VALUE);
            buf.writeInt(recipe.getInputItem().size());
            for (Ingredient ing : recipe.getInputItem()) {
                ing.m_43923_(buf);
            }
            buf.m_130072_(recipe.summonedMob, Short.MAX_VALUE);
        }
    }

    public static class Type
    implements RecipeType<SummoningRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

