/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.integration.jei;

import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.integration.jei.JEIStrainersPlugin;
import com.benbenlaw.strainers.recipe.SummoningRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningRecipeCategory
implements IRecipeCategory<SummoningRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("strainers", "summoning");
    public static final ResourceLocation TEXTURE = new ResourceLocation("strainers", "textures/gui/jei_summoning_block.png");
    static final RecipeType<SummoningRecipe> RECIPE_TYPE = RecipeType.create((String)"strainers", (String)"summoning", SummoningRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SummoningRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 103, 40);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SUMMONING_BLOCK.get()));
    }

    public RecipeType<SummoningRecipe> getRecipeType() {
        return JEIStrainersPlugin.SUMMONING;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Summoning");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SummoningRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 13).addIngredients((Ingredient)recipe.getInputItem().get(0));
        String blockBelow = recipe.getBlockBelow();
        Block blockBelowAsBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockBelow));
        assert (blockBelowAsBlock != null);
        if (!blockBelowAsBlock.m_5456_().equals(Items.f_41852_)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 4, 23).addItemStack(new ItemStack((ItemLike)blockBelowAsBlock));
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(recipe.getFluidBelow()));
        assert (fluid != null);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 4, 23).addFluidStack(fluid, 1000L)).setFluidRenderer(1000L, true, 16, 16);
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 3).addItemStack(new ItemStack((ItemLike)ModBlocks.SUMMONING_BLOCK.get()));
        @Nullable EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(recipe.getSummonedMob()));
        assert (entity != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 13).addItemStack(new ItemStack((ItemLike)((Ingredient)recipe.getInputItem().get(1)).m_43908_()[0].m_41720_()).m_41714_((Component)Component.m_237113_((String)("Summon " + entity.m_20676_().getString()))));
    }
}

