/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.data.custom;

import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class StrainerRecipeBlockBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final int count;
    private final double outputChance;
    private final double chanceIncreasePerTier;
    private final int meshTier;
    private final int duration;
    private final String blockAbove;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public StrainerRecipeBlockBuilder(ItemLike ingredient, ItemLike result, int count, double outputChance, double chanceIncreasePerTier, int meshTier, int duration, String blockAbove) {
        this.ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        this.result = result.m_5456_();
        this.count = count;
        this.outputChance = outputChance;
        this.chanceIncreasePerTier = chanceIncreasePerTier;
        this.meshTier = meshTier;
        this.duration = duration;
        this.blockAbove = blockAbove;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@org.checkerframework.checker.nullness.qual.Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public double getChanceIncreasePerTier() {
        return this.chanceIncreasePerTier;
    }

    public double getOutputChance() {
        return this.outputChance;
    }

    public int getMeshTier() {
        return this.meshTier;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getBlockAbove() {
        return this.blockAbove;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.count, this.ingredient, this.outputChance, this.chanceIncreasePerTier, this.meshTier, this.duration, this.blockAbove, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + pRecipeId.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final Ingredient ingredient;
        private final int count;
        private final double outputChance;
        private final double chanceIncreasePerTier;
        private final int meshTier;
        private final int duration;
        private final String blockAbove;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation pId, Item pResult, int pCount, Ingredient ingredient, double outputChance, double chanceIncreasePerTier, int meshTier, int duration, String blockAbove, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId) {
            this.id = pId;
            this.result = pResult;
            this.count = pCount;
            this.ingredient = ingredient;
            this.outputChance = outputChance;
            this.chanceIncreasePerTier = chanceIncreasePerTier;
            this.meshTier = meshTier;
            this.duration = duration;
            this.blockAbove = blockAbove;
            this.advancement = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            JsonObject outputJSON = new JsonObject();
            outputJSON.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                outputJSON.addProperty("count", (Number)this.count);
            }
            pJson.add("output", (JsonElement)outputJSON);
            JsonArray jsonarray = new JsonArray();
            jsonarray.add(this.ingredient.m_43942_());
            pJson.add("ingredients", (JsonElement)jsonarray);
            pJson.addProperty("chance", (Number)this.outputChance);
            pJson.addProperty("minMeshTier", (Number)this.meshTier);
            pJson.addProperty("chanceIncreasePerTier", (Number)this.chanceIncreasePerTier);
            pJson.addProperty("duration", (Number)this.duration);
            pJson.addProperty("aboveBlock", this.blockAbove);
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation("strainers", ForgeRegistries.ITEMS.getKey((Object)this.result).m_135815_() + "_from_straining_" + this.ingredient.m_43908_()[0].m_41720_() + "_in_" + this.blockAbove.replace(":", "_"));
        }

        public RecipeSerializer<?> m_6637_() {
            return StrainerRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

