/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity.client;

import com.benbenlaw.opolisutilities.util.RenderUtil;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StrainerTankBlockEntityRenderer
implements BlockEntityRenderer<StrainerTankBlockEntity> {
    public StrainerTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StrainerTankBlockEntity entity, float ticks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        if (!entity.getFluidStack().isEmpty()) {
            FluidStack fluid = entity.getFluidStack();
            VertexConsumer buffer = multiBufferSource.m_6299_(Sheets.m_110792_());
            PoseStack.Pose last = poseStack.m_85850_();
            StrainerTankBlockEntityRenderer.renderFluid(last.m_252922_(), last.m_252943_(), buffer, entity, fluid.getFluid(), (float)entity.FLUID_TANK.getFluidAmount() / (float)entity.FLUID_TANK.getCapacity(), light);
        }
    }

    private static void renderFluid(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, BlockEntity entity, Fluid fluid, float fillAmount, int packedLight) {
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.m_76145_(), (BlockAndTintGetter)entity.m_58904_(), entity.m_58899_());
        StrainerTankBlockEntityRenderer.renderFluid(pose, normal, consumer, fluid, fillAmount, color, packedLight);
    }

    public static void renderFluid(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, Fluid fluid, float fillAmount, int color, int packedLight) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(props.getStillTexture());
        float fluidHeight = 14.0f * fillAmount / 16.0f;
        float inset = 0.0625f;
        float faceSize = 0.875f;
        RenderUtil.renderFace((Direction)Direction.UP, (Matrix4f)pose, (Matrix3f)normal, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)(inset + fluidHeight), (float)faceSize, (float)faceSize, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.SOUTH, (Matrix4f)pose, (Matrix3f)normal, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.NORTH, (Matrix4f)pose, (Matrix3f)normal, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.EAST, (Matrix4f)pose, (Matrix3f)normal, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
        RenderUtil.renderFace((Direction)Direction.WEST, (Matrix4f)pose, (Matrix3f)normal, (VertexConsumer)consumer, (TextureAtlasSprite)texture, (float)inset, (float)inset, (float)inset, (float)faceSize, (float)fluidHeight, (int)color, (int)packedLight);
    }
}

