/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity.client;

import com.benbenlaw.strainers.block.entity.WoodenStrainerBlockEntity;
import com.benbenlaw.strainers.config.StrainersConfigFile;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class StrainerMeshEntityRenderer
implements BlockEntityRenderer<WoodenStrainerBlockEntity> {
    public StrainerMeshEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WoodenStrainerBlockEntity entity, float ticks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack mesh = entity.getItemStackHandler().getStackInSlot(1);
        ItemStack insideItem = entity.getItemStackHandler().getStackInSlot(2);
        int progress = entity.progress;
        int maxProgress = entity.maxProgress;
        if (StrainersConfigFile.SPEC.isLoaded()) {
            if (!mesh.m_41619_() && ((Boolean)StrainersConfigFile.showMeshesInWorld.get()).booleanValue()) {
                poseStack.m_85836_();
                for (Direction direction : Direction.values()) {
                    if (direction == Direction.UP || direction == Direction.DOWN) continue;
                    poseStack.m_85836_();
                    poseStack.m_252880_(0.0f, 1.23f, 0.0f);
                    poseStack.m_85841_(1.9f, 1.9f, 1.9f);
                    switch (direction) {
                        case NORTH: {
                            poseStack.m_85837_(0.26, 0.0, (double)0.02f);
                            break;
                        }
                        case SOUTH: {
                            poseStack.m_85837_(0.26, 0.0, 0.5);
                            break;
                        }
                        case WEST: {
                            poseStack.m_85837_(0.5, 0.0, 0.26);
                            poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
                            break;
                        }
                        case EAST: {
                            poseStack.m_85837_((double)0.02f, 0.0, 0.26);
                            poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
                        }
                    }
                    BakedModel model = itemRenderer.m_174264_(mesh, null, null, 0);
                    itemRenderer.m_115143_(mesh, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.m_58904_(), entity.m_58899_().m_7494_()), overlay, model);
                    poseStack.m_85849_();
                }
                poseStack.m_85849_();
            }
            if (((Boolean)StrainersConfigFile.showItemBeingStrainerInWorld.get()).booleanValue()) {
                if (insideItem.m_41720_() instanceof BlockItem) {
                    double percentageValue = 100.0 / (double)maxProgress;
                    double totalCompletedValue = percentageValue * (double)progress;
                    float adjustedFloat = (float)(totalCompletedValue / 100.0);
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.5, (double)(1.0f - adjustedFloat), 0.5);
                    poseStack.m_85841_(3.1f, 3.1f, 3.1f);
                    BakedModel insideModel = itemRenderer.m_174264_(insideItem, null, null, 0);
                    itemRenderer.m_115143_(insideItem, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.m_58904_(), entity.m_58899_().m_7494_()), overlay, insideModel);
                    poseStack.m_85849_();
                } else {
                    poseStack.m_85836_();
                    for (Direction direction : Direction.values()) {
                        if (direction == Direction.UP || direction == Direction.DOWN) continue;
                        poseStack.m_85836_();
                        poseStack.m_252880_(0.0f, 0.25f, 0.0f);
                        poseStack.m_85841_(1.9f, 1.9f, 1.9f);
                        switch (direction) {
                            case NORTH: {
                                poseStack.m_85837_(0.26, 0.0, (double)0.02f);
                                break;
                            }
                            case SOUTH: {
                                poseStack.m_85837_(0.26, 0.0, 0.5);
                                break;
                            }
                            case WEST: {
                                poseStack.m_85837_(0.5, 0.0, 0.26);
                                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(90.0)));
                                break;
                            }
                            case EAST: {
                                poseStack.m_85837_((double)0.02f, 0.0, 0.26);
                                poseStack.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
                            }
                        }
                        BakedModel insideModel = itemRenderer.m_174264_(insideItem, null, null, 0);
                        itemRenderer.m_115143_(insideItem, ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, this.getLightLevel(entity.m_58904_(), entity.m_58899_().m_7494_()), overlay, insideModel);
                        poseStack.m_85849_();
                    }
                    poseStack.m_85849_();
                }
            }
        }
    }

    public float getProgress(WoodenStrainerBlockEntity entity) {
        return (float)entity.progress / (float)entity.maxProgress;
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }
}

