/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.entity;

import com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import com.benbenlaw.strainers.block.ModBlocks;
import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.benbenlaw.strainers.networking.ModMessages;
import com.benbenlaw.strainers.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.strainers.recipe.StrainerRecipe;
import com.benbenlaw.strainers.screen.WoodenStrainerMenu;
import com.benbenlaw.strainers.util.ModTags;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenStrainerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            WoodenStrainerBlockEntity.this.m_6596_();
            assert (WoodenStrainerBlockEntity.this.f_58857_ != null);
            if (!WoodenStrainerBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, WoodenStrainerBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (i, s) -> false)), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (index, stack) -> {
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        if (index == 2 && this.itemHandler.isItemValid(2, stack)) {
            return stack.m_204131_().noneMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        return false;
    })), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (index, stack) -> {
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        if (index == 2 && this.itemHandler.isItemValid(2, stack)) {
            return stack.m_204131_().noneMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        return false;
    })), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (index, stack) -> {
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        if (index == 2 && this.itemHandler.isItemValid(2, stack)) {
            return stack.m_204131_().noneMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        return false;
    })), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (index, stack) -> {
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        if (index == 2 && this.itemHandler.isItemValid(2, stack)) {
            return stack.m_204131_().noneMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        return false;
    })), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i >= 3 && i <= 26, (index, stack) -> {
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        if (index == 2 && this.itemHandler.isItemValid(2, stack)) {
            return stack.m_204131_().noneMatch(arg_0 -> ModTags.Items.MESHES.equals(arg_0));
        }
        return false;
    })));
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 1000;
    double durationMultiplier = 1.0;
    double outputChance = 0.0;
    int outputRuns = 0;
    double inputMultiplier = 1.0;
    double meshMultiplier = 1.0;
    int meshExtraDamage = 0;
    int inputItemExtraAmount = 0;
    ItemStack upgradeItem = ItemStack.f_41583_;

    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public WoodenStrainerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WOODEN_STRAINER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> WoodenStrainerBlockEntity.this.progress;
                    case 1 -> WoodenStrainerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        WoodenStrainerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        WoodenStrainerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Strainer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, @NotNull Inventory inventory, @NotNull Player player) {
        return new WoodenStrainerMenu(containerID, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("wooden_strainer.progress", this.progress);
        tag.m_128405_("wooden_strainer.maxProgress", this.maxProgress);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("wooden_strainer.progress");
        this.maxProgress = nbt.m_128451_("wooden_strainer.maxProgress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            BlockPos pPos = this.f_58858_;
            BlockState pState = pLevel.m_8055_(pPos);
            WoodenStrainerBlockEntity pBlockEntity = this;
            if (!this.itemHandler.getStackInSlot(0).m_150930_(this.upgradeItem.m_41720_())) {
                this.updateUpgrades(pBlockEntity);
            }
            if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.upgradeItem = ItemStack.f_41583_;
                this.durationMultiplier = 1.0;
                this.outputChance = 0.0;
                this.outputRuns = 0;
                this.inputMultiplier = 1.0;
                this.meshMultiplier = 1.0;
                this.meshExtraDamage = 0;
                this.inputItemExtraAmount = 0;
            }
            if (this.hasRecipe(pBlockEntity)) {
                ++pBlockEntity.progress;
                WoodenStrainerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                    this.craftItem(pBlockEntity);
                }
            } else {
                pBlockEntity.resetProgress();
                WoodenStrainerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    private boolean hasRecipe(@NotNull WoodenStrainerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional match = level.m_7465_().m_44015_((RecipeType)StrainerRecipe.Type.INSTANCE, (Container)inventory, level);
        List allRecipes = level.m_7465_().m_44013_((RecipeType)StrainerRecipe.Type.INSTANCE);
        List matchingRecipes = allRecipes.stream().filter(recipe -> recipe.matches(inventory, level)).collect(Collectors.toList());
        BlockPos blockPos = entity.f_58858_.m_6630_(1);
        BlockState blockAbove = level.m_8055_(blockPos);
        FluidState fluidAbove = level.m_6425_(blockPos);
        if (!matchingRecipes.isEmpty()) {
            for (StrainerRecipe matching : matchingRecipes) {
                entity.maxProgress = (int)((double)matching.getDuration() * this.durationMultiplier);
                Fluid fluidInRecipe = null;
                if (matching.getBlockAbove().isEmpty()) {
                    fluidInRecipe = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(matching.getFluidAbove()));
                }
                Block blockInRecipe = null;
                if (matching.getFluidAbove().isEmpty()) {
                    blockInRecipe = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(matching.getBlockAbove()));
                }
                if (blockAbove.m_60795_() && !blockAbove.m_60713_(blockInRecipe)) continue;
                FluidState fluidInTank = null;
                if (blockAbove.m_60713_((Block)ModBlocks.STRAINER_TANK.get())) {
                    fluidInTank = ((StrainerTankBlockEntity)level.m_7702_(blockPos)).getFluidStack().getFluid().m_76145_();
                }
                if (fluidInTank == null) {
                    fluidInTank = fluidAbove;
                }
                boolean isFluidMatching = fluidInTank.m_192917_(fluidInRecipe) || fluidAbove.m_192917_(fluidInRecipe);
                boolean isBlockMatching = blockAbove.m_60713_(blockInRecipe) && matching.getBlockAbove().isEmpty() && !blockAbove.m_60713_((Block)ModBlocks.STRAINER_TANK.get()) && fluidAbove.m_192917_(Fluids.f_76191_);
                boolean isAirBlockRecipe = blockAbove.m_60713_(blockInRecipe);
                if (!isFluidMatching && !isBlockMatching && !isAirBlockRecipe) continue;
                return match.filter(currentRecipe -> this.hasMeshItem(entity, (StrainerRecipe)currentRecipe) && this.hasInputItem(entity, (StrainerRecipe)currentRecipe) && this.canStartRecipe(inventory, currentRecipe.getOutput()) && this.hasCorrectCountInInputUpgrading(entity) && this.hasDuration((StrainerRecipe)currentRecipe)).isPresent();
            }
        }
        return false;
    }

    private void updateUpgrades(@NotNull WoodenStrainerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        List upgradeRecipe = level.m_7465_().m_44013_((RecipeType)UpgradeRecipeUtil.Type.INSTANCE);
        List matchingUpgradeRecipes = upgradeRecipe.stream().filter(recipe -> recipe.matches(inventory, level)).collect(Collectors.toList());
        if (!matchingUpgradeRecipes.isEmpty()) {
            for (UpgradeRecipeUtil matchingUpgrade : matchingUpgradeRecipes) {
                if (!this.itemHandler.getStackInSlot(0).m_150930_(matchingUpgrade.getUpgradeItem().m_41720_())) continue;
                this.durationMultiplier = matchingUpgrade.getDurationMultiplier();
                this.outputChance = matchingUpgrade.getOutputIncreaseChance();
                this.upgradeItem = matchingUpgrade.getUpgradeItem();
                this.outputRuns = matchingUpgrade.getOutputIncreaseAmount();
                this.inputMultiplier = matchingUpgrade.getInputItemConsumeChance();
                this.meshMultiplier = matchingUpgrade.getMeshUseChance();
                this.meshExtraDamage = matchingUpgrade.getMeshExtraDamage();
                this.inputItemExtraAmount = matchingUpgrade.getInputItemExtraAmount();
                break;
            }
        } else {
            this.outputChance = 0.0;
            this.upgradeItem = ItemStack.f_41583_;
        }
    }

    private void craftItem(@NotNull WoodenStrainerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        List allRecipes = level.m_7465_().m_44013_((RecipeType)StrainerRecipe.Type.INSTANCE);
        List matchingRecipes = allRecipes.stream().filter(recipe -> recipe.matches(inventory, level)).collect(Collectors.toList());
        if (!matchingRecipes.isEmpty()) {
            for (StrainerRecipe match : matchingRecipes) {
                Random random = new Random();
                double chance = random.nextDouble();
                int additionalOutputRuns = 0;
                if (chance > this.outputChance && this.outputChance != 0.0) {
                    additionalOutputRuns = 1;
                }
                additionalOutputRuns += this.outputRuns;
                for (int run = 0; run < 1 + additionalOutputRuns; ++run) {
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(match.getFluidAbove()));
                    Block blockInRecipe = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(match.getBlockAbove()));
                    BlockPos blockPos = entity.f_58858_.m_6630_(1);
                    BlockState blockAbove = level.m_8055_(blockPos);
                    FluidState fluidAbove = level.m_6425_(blockPos);
                    if (blockAbove.m_60713_((Block)ModBlocks.STRAINER_TANK.get())) {
                        fluidAbove = ((StrainerTankBlockEntity)level.m_7702_(blockPos)).getFluidStack().getFluid().m_76145_();
                    }
                    if (!blockAbove.m_60713_(blockInRecipe) && !match.getBlockAbove().isEmpty() || !fluidAbove.m_192917_(fluid) && !match.getFluidAbove().isEmpty()) continue;
                    int meshTierStrainer = this.getMeshTierInStrainer(entity, match);
                    int outputBoost = meshTierStrainer - match.getMeshTier();
                    if (match.getOutput().m_41619_() || !(Math.random() < match.getOutputChance() + match.getChanceIncreasePerTier() * (double)outputBoost)) continue;
                    for (int i = 3; !(i > 26 || entity.itemHandler.isItemValid(i, match.getOutput().m_41720_().m_7968_()) && entity.itemHandler.insertItem(i, new ItemStack((ItemLike)match.getOutput().m_41720_(), match.getOutput().m_41613_()), false).m_41619_()); ++i) {
                    }
                }
            }
            if (!entity.itemHandler.getStackInSlot(2).m_41763_() || entity.itemHandler.getStackInSlot(2).m_204117_(ModTags.Items.REMOVE_ITEM_NO_DAMAGE_IN_STRAINER)) {
                if (this.inputMultiplier != 1.0) {
                    if (Math.random() > this.inputMultiplier) {
                        entity.itemHandler.extractItem(2, 0, false);
                    } else {
                        entity.itemHandler.extractItem(2, 1 + this.inputItemExtraAmount, false);
                    }
                } else {
                    entity.itemHandler.extractItem(2, 1 + this.inputItemExtraAmount, false);
                }
            }
            if (entity.itemHandler.getStackInSlot(2).m_41763_()) {
                if (this.inputMultiplier != 1.0) {
                    if (Math.random() > this.inputMultiplier) {
                        if (entity.itemHandler.getStackInSlot(2).m_220157_(0, RandomSource.m_216327_(), null)) {
                            entity.itemHandler.extractItem(2, 0, false);
                        }
                    } else if (entity.itemHandler.getStackInSlot(2).m_220157_(1 + this.inputItemExtraAmount, RandomSource.m_216327_(), null)) {
                        entity.itemHandler.extractItem(2, 1 + this.inputItemExtraAmount, false);
                    }
                } else if (entity.itemHandler.getStackInSlot(2).m_220157_(1 + this.inputItemExtraAmount, RandomSource.m_216327_(), null)) {
                    entity.itemHandler.extractItem(2, 1 + this.inputItemExtraAmount, false);
                }
            }
            if (this.meshMultiplier != 1.0) {
                if (Math.random() > this.meshMultiplier) {
                    if (entity.itemHandler.getStackInSlot(1).m_220157_(0, RandomSource.m_216327_(), null)) {
                        entity.itemHandler.extractItem(1, 0, false);
                    } else if (entity.itemHandler.getStackInSlot(1).m_220157_(1 + this.meshExtraDamage, RandomSource.m_216327_(), null)) {
                        entity.itemHandler.extractItem(1, 1, false);
                    }
                }
            } else if (entity.itemHandler.getStackInSlot(1).m_220157_(1 + this.meshExtraDamage, RandomSource.m_216327_(), null)) {
                entity.itemHandler.extractItem(1, 1, false);
            }
            entity.resetProgress();
        }
    }

    public void updateProgressValues(WoodenStrainerBlockEntity entity) {
        this.progress = entity.progress;
        this.maxProgress = entity.maxProgress;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 1000;
    }

    private boolean hasDuration(StrainerRecipe recipe) {
        return 0 <= recipe.getDuration();
    }

    private boolean hasMeshItem(WoodenStrainerBlockEntity entity, StrainerRecipe recipe) {
        ItemStack meshItem = entity.itemHandler.getStackInSlot(1);
        if (recipe.getMeshTier() == 1) {
            return meshItem.m_204117_(ModTags.Items.TIER_1_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_2_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMeshTier() == 2) {
            return meshItem.m_204117_(ModTags.Items.TIER_2_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMeshTier() == 3) {
            return meshItem.m_204117_(ModTags.Items.TIER_3_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMeshTier() == 4) {
            return meshItem.m_204117_(ModTags.Items.TIER_4_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMeshTier() == 5) {
            return meshItem.m_204117_(ModTags.Items.TIER_5_MESHES) || meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        if (recipe.getMeshTier() == 6) {
            return meshItem.m_204117_(ModTags.Items.TIER_6_MESHES);
        }
        return false;
    }

    public int getMeshTierInStrainer(WoodenStrainerBlockEntity entity, StrainerRecipe recipe) {
        if (this.hasMeshItem(entity, recipe)) {
            Item meshItem = entity.itemHandler.getStackInSlot(1).m_41720_();
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_6_MESHES)) {
                return 6;
            }
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_5_MESHES)) {
                return 5;
            }
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_4_MESHES)) {
                return 4;
            }
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_3_MESHES)) {
                return 3;
            }
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_2_MESHES)) {
                return 2;
            }
            if (meshItem.m_5456_().m_7968_().m_204117_(ModTags.Items.TIER_1_MESHES)) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasInputItem(@NotNull WoodenStrainerBlockEntity entity, @NotNull StrainerRecipe recipe) {
        ItemStack[] items = ((Ingredient)recipe.m_7527_().get(0)).m_43908_();
        ItemStack slotItem = entity.itemHandler.getStackInSlot(2);
        for (ItemStack item : items) {
            if (!ItemStack.m_41656_((ItemStack)item, (ItemStack)slotItem)) continue;
            return true;
        }
        return false;
    }

    private boolean canStartRecipe(SimpleContainer inventory, ItemStack stack) {
        int emptySlotCounter = 0;
        int occupiedSlotCounter = 0;
        for (int i = 3; i <= 26; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) {
                ++emptySlotCounter;
                continue;
            }
            if (itemStack.m_41720_() == stack.m_41720_()) {
                int availableSpace = stack.m_41613_();
                if (availableSpace > 0) continue;
                return false;
            }
            ++occupiedSlotCounter;
        }
        return occupiedSlotCounter != 26 && emptySlotCounter != 0;
    }

    private boolean hasCorrectCountInInputUpgrading(WoodenStrainerBlockEntity entity) {
        return entity.itemHandler.getStackInSlot(2).m_41613_() >= this.inputItemExtraAmount + 1;
    }
}

