/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.sunbeam;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.sunbeam.SunbeamEntity;
import io.redspace.ironsspellbooks.render.RenderHelper;
import io.redspace.ironsspellbooks.render.SpellRenderingHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SunbeamRenderer
extends EntityRenderer<SunbeamEntity> {
    public SunbeamRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(SunbeamEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    public void render(SunbeamEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        float maxRadius = 2.5f;
        float minRadius = 0.005f;
        float deltaTicks = (float)entity.f_19797_ + partialTicks;
        float deltaUV = -deltaTicks % 10.0f;
        float max = Mth.m_14187_((float)(deltaUV * 0.2f - (float)Mth.m_14143_((float)(deltaUV * 0.1f))));
        float min = -1.0f + max;
        float f = deltaTicks / 15.0f;
        f *= f;
        float radius = Mth.m_144920_((float)maxRadius, (float)minRadius, (float)f);
        VertexConsumer inner = bufferSource.m_6299_(RenderHelper.CustomerRenderType.magic(SpellRenderingHelper.BEACON));
        float halfRadius = radius * 0.5f;
        float quarterRadius = halfRadius * 0.5f;
        float yMin = entity.m_20096_() ? 0.0f : Utils.findRelativeGroundLevel(entity.f_19853_, entity.m_20182_(), 8) - (float)entity.m_20186_();
        for (int i = 0; i < 4; ++i) {
            int r = (int)(Mth.m_14036_((float)(0.8f * f), (float)0.0f, (float)1.0f) * 255.0f);
            int g = (int)(Mth.m_14036_((float)(0.8f * f * f), (float)0.0f, (float)1.0f) * 255.0f);
            int b = (int)(Mth.m_14036_((float)(0.5f * f * f), (float)0.0f, (float)1.0f) * 255.0f);
            int a = 255;
            Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
            Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
            inner.m_252986_(poseMatrix, -halfRadius, yMin, -halfRadius).m_6122_(r, g, b, a).m_7421_(0.0f, min).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -halfRadius, yMin, halfRadius).m_6122_(r, g, b, a).m_7421_(1.0f, min).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -halfRadius, 250.0f, halfRadius).m_6122_(r, g, b, a).m_7421_(1.0f, max).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -halfRadius, 250.0f, -halfRadius).m_6122_(r, g, b, a).m_7421_(0.0f, max).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            int color = RenderHelper.colorf(Mth.m_14036_((float)(1.0f * f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(0.85f * f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(0.7f * f * f), (float)0.0f, (float)1.0f));
            inner.m_252986_(poseMatrix, -quarterRadius, yMin, -quarterRadius).m_193479_(color).m_7421_(0.0f, min).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -quarterRadius, yMin, quarterRadius).m_193479_(color).m_7421_(1.0f, min).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -quarterRadius, 250.0f, quarterRadius).m_193479_(color).m_7421_(1.0f, max).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            inner.m_252986_(poseMatrix, -quarterRadius, 250.0f, -quarterRadius).m_193479_(color).m_7421_(0.0f, max).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(SunbeamEntity entity) {
        return SpellRenderingHelper.BEACON;
    }
}

