/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.init.CoreRecipeSerializers;
import cofh.lib.util.crafting.ShapedRecipeInternal;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class ShapedPotionNBTRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    private final ShapedRecipeInternal wrappedRecipe;

    public ShapedPotionNBTRecipe(ResourceLocation pId, String pGroup, CraftingBookCategory pCategory, int pWidth, int pHeight, NonNullList<Ingredient> pRecipeItems, ItemStack pResult) {
        this.wrappedRecipe = new ShapedRecipeInternal(pId, pGroup, pCategory, pWidth, pHeight, pRecipeItems, pResult);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean potionItem = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() != Items.f_42589_ || PotionUtils.m_43547_((ItemStack)stack).isEmpty()) continue;
            potionItem = true;
            break;
        }
        return potionItem && this.wrappedRecipe.matches(inv, worldIn);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack result = this.wrappedRecipe.m_8043_(registryAccess).m_41777_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() != Items.f_42589_ || stack.m_41783_() == null) continue;
            result.m_41751_(stack.m_41783_().m_6426_());
            break;
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return this.wrappedRecipe.m_8004_(width, height);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.wrappedRecipe.m_8043_(registryAccess);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.wrappedRecipe.m_7527_();
    }

    public ResourceLocation m_6423_() {
        return this.wrappedRecipe.m_6423_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CoreRecipeSerializers.SHAPED_POTION_RECIPE_SERIALIZER.get();
    }

    public int getRecipeWidth() {
        return this.wrappedRecipe.getWidth();
    }

    public int getRecipeHeight() {
        return this.wrappedRecipe.getHeight();
    }

    public CraftingBookCategory m_245232_() {
        return this.wrappedRecipe.category;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedPotionNBTRecipe> {
        public ShapedPotionNBTRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ShapedRecipeInternal.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipeInternal.shrink(ShapedRecipeInternal.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = ShapedRecipeInternal.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapedPotionNBTRecipe(recipeId, s, craftingbookcategory, i, j, nonnulllist, itemstack);
        }

        public ShapedPotionNBTRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String s = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new ShapedPotionNBTRecipe(recipeId, s, craftingbookcategory, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedPotionNBTRecipe recipe) {
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.wrappedRecipe.result);
        }
    }
}

