/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.effect;

import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.lib.common.effect.CustomParticleMobEffect;
import cofh.lib.util.helpers.MathHelper;
import java.util.random.RandomGenerator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ChilledMobEffect
extends CustomParticleMobEffect {
    public ChilledMobEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
    }

    @Override
    public void m_6742_(LivingEntity living, int amplifier) {
        super.m_6742_(living, amplifier);
        if (living.m_142079_()) {
            living.f_146808_ = true;
            living.m_146917_(Math.min(living.m_146891_(), living.m_146888_() + 2 + amplifier * 2));
        }
    }

    public double m_7048_(int amplifier, AttributeModifier modifier) {
        return Math.max(-0.9, super.m_7048_(amplifier, modifier));
    }

    @Override
    public ParticleOptions getParticle() {
        return (ParticleOptions)CoreParticles.FROST.get();
    }

    public static void applyChilled(LivingEntity target, float power, RandomGenerator rand) {
        int add = MathHelper.round(power * 8.0f);
        MobEffectInstance instance = target.m_21124_((MobEffect)CoreMobEffects.CHILLED.get());
        if (instance == null) {
            target.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), add, 0, true, false, true));
        } else {
            int duration = instance.m_19557_();
            int amplifier = instance.m_19564_();
            if (amplifier < 5 && rand.nextFloat(250.0f) < (float)duration) {
                target.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), add, amplifier + 1, true, false, true));
            } else if (duration < 250) {
                target.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.CHILLED.get(), duration + add, amplifier, true, false, true));
            }
        }
    }

    public static void applyChilled(Entity target, float power, RandomGenerator rand) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ChilledMobEffect.applyChilled(living, power, rand);
        }
    }
}

