/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.event;

import cofh.core.common.capability.CapabilityAreaEffect;
import cofh.core.common.capability.templates.AreaEffectItemWrapper;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class AreaEffectClientEvents {
    private AreaEffectClientEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderBlockHighlights(RenderHighlightEvent.Block event) {
        if (event.isCanceled()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!AreaEffectHelper.validAreaEffectItem(stack)) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffectItem)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getTarget().m_82425_(), (Player)player);
        LevelRenderer levelRenderer = event.getLevelRenderer();
        PoseStack matrix = event.getPoseStack();
        VertexConsumer vertexBuilder = levelRenderer.f_109464_.m_110104_().m_6299_(RenderType.m_110504_());
        Entity viewEntity = camera.m_90592_();
        Level world = player.f_19853_;
        Vec3 vec3d = camera.m_90583_();
        double d0 = vec3d.m_7096_();
        double d1 = vec3d.m_7098_();
        double d2 = vec3d.m_7094_();
        matrix.m_85836_();
        for (BlockPos pos : areaBlocks) {
            if (!world.m_6857_().m_61937_(pos)) continue;
            levelRenderer.m_109637_(matrix, vertexBuilder, viewEntity, d0, d1, d2, pos, world.m_8055_(pos));
        }
        matrix.m_85849_();
        MultiPlayerGameMode gamemode = Minecraft.m_91087_().f_91072_;
        if (gamemode == null || !gamemode.m_105296_()) {
            return;
        }
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        AreaEffectClientEvents.drawBlockDamageTexture(gamemode, event.getLevelRenderer(), event.getPoseStack(), Minecraft.m_91087_().f_91063_.m_109153_(), player.m_20193_(), areaBlocks);
    }

    private static void drawBlockDamageTexture(MultiPlayerGameMode gameMode, LevelRenderer levelRenderer, PoseStack posestack, Camera camera, Level level, List<BlockPos> areaBlocks) {
        double d0 = camera.m_90583_().f_82479_;
        double d1 = camera.m_90583_().f_82480_;
        double d2 = camera.m_90583_().f_82481_;
        int progress = (int)(gameMode.f_105193_ * 10.0f) - 1;
        if (progress < 0 || progress > 10) {
            return;
        }
        progress = Math.min(progress + 1, 9);
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        VertexConsumer vertexBuilder = levelRenderer.f_109464_.m_110108_().m_6299_((RenderType)ModelBakery.f_119229_.get(progress));
        for (BlockPos pos : areaBlocks) {
            posestack.m_85836_();
            posestack.m_85837_((double)pos.m_123341_() - d0, (double)pos.m_123342_() - d1, (double)pos.m_123343_() - d2);
            PoseStack.Pose matrixEntry = posestack.m_85850_();
            SheetedDecalTextureGenerator matrixBuilder = new SheetedDecalTextureGenerator(vertexBuilder, matrixEntry.m_252922_(), matrixEntry.m_252943_(), 1.0f);
            dispatcher.m_110918_(level.m_8055_(pos), pos, (BlockAndTintGetter)level, posestack, (VertexConsumer)matrixBuilder);
            posestack.m_85849_();
        }
    }
}

