/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class BornInChaosSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private BornInChaosSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} {} Spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn", (Object)"Born in Chaos");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/BornInChaosSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue hostileMobsPerPlayer;
        public final ForgeConfigSpec.IntValue hostileMobsPerWorld;
        public final ForgeConfigSpec.IntValue hostileMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> hostileMobsList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Born in Chaos Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"born_in_chaos_v1");
            this.hostileMobsPerPlayer = builder.defineInRange("HostileMobsPerPlayer", 16, 1, 64);
            this.hostileMobsPerWorld = builder.defineInRange("HostileMobsPerWorld", 32, 1, 512);
            this.hostileMobsPerServer = builder.defineInRange("HostileMobsPerServer", 320, 1, 1024);
            this.hostileMobsList = builder.comment("List of hostile Mobs to optimize in the format [\"minecraft:blaze\", \"minecraft:cave_spider\", ..]").define("HostileMobsList", new ArrayList<String>(Arrays.asList("born_in_chaos_v1:baby_s_2", "born_in_chaos_v1:baby_skeleton", "born_in_chaos_v1:bone_imp", "born_in_chaos_v1:bone_imp_2", "born_in_chaos_v1:bonescaller", "born_in_chaos_v1:dark_vortex", "born_in_chaos_v1:decaying_zombie", "born_in_chaos_v1:decrepit_skeleton", "born_in_chaos_v1:diamond_thermite", "born_in_chaos_v1:dread_hound", "born_in_chaos_v1:fallen_chaos_knight", "born_in_chaos_v1:firelight", "born_in_chaos_v1:mr_pumpkin", "born_in_chaos_v1:nightmare_stalker", "born_in_chaos_v1:phantom_creeper", "born_in_chaos_v1:pumpkin_spirit", "born_in_chaos_v1:restless_spirit", "born_in_chaos_v1:scarletpersecutor", "born_in_chaos_v1:seared_spirit", "born_in_chaos_v1:shy_spirit", "born_in_chaos_v1:skeleton_bomb", "born_in_chaos_v1:skeleton_thrasher", "born_in_chaos_v1:spirit_guide_assistant", "born_in_chaos_v1:spiritual_guide", "born_in_chaos_v1:supreme_bonecaller", "born_in_chaos_v1:wither_strider", "born_in_chaos_v1:zombie_clown", "born_in_chaos_v1:zombiesina_barrel", "born_in_chaos_v1:zombieswith_door")));
            builder.pop();
        }
    }
}

