/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private CommonConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} common config ...", (Object)"Adaptive Performance Tweaks: Spawn");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks/spawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.ConfigValue<List<String>> spawnAllowList;
        public final ForgeConfigSpec.ConfigValue<List<String>> spawnDenyList;
        public final ForgeConfigSpec.ConfigValue<List<String>> spawnIgnoreDimensionList;
        public final ForgeConfigSpec.BooleanValue spawnAggressiveMode;
        public final ForgeConfigSpec.BooleanValue viewAreaEnabled;
        public final ForgeConfigSpec.IntValue friendlyChunkSpawnRate;
        public final ForgeConfigSpec.BooleanValue spawnLimitationEnabled;
        public final ForgeConfigSpec.IntValue spawnLimitationLimiter;
        public final ForgeConfigSpec.IntValue spawnLimitationMaxMobsPerPlayer;
        public final ForgeConfigSpec.IntValue spawnLimitationMaxMobsPerWorld;
        public final ForgeConfigSpec.IntValue spawnLimitationMaxMobsPerServer;
        public final ForgeConfigSpec.BooleanValue spawnEggBypassLimitations;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("General");
            this.spawnAllowList = builder.comment("General allow list for spawn entities (e.g. minecraft:squid) which should be ignored for optimization.").define("allowList", new ArrayList<String>(List.of("")));
            this.spawnDenyList = builder.comment("General deny list for spawn entities (e.g. minecraft:bat) to no longer spawn in all worlds.").define("denyList", new ArrayList<String>(List.of("")));
            this.spawnIgnoreDimensionList = builder.comment("General list of ignored dimensions.").define("spawnIgnoreDimensionList", new ArrayList<String>(List.of("minecraft:the_end")));
            this.spawnAggressiveMode = builder.comment("Enable/Disable more aggressive and strict spawn limitations.").define("spawnAggressiveMode", false);
            builder.pop();
            builder.push("Chunk Optimization");
            this.friendlyChunkSpawnRate = builder.comment("Allows to spawn at least one mob (regardless of the type) per selected chunk to avoid side effects.A value of 9 means every 9 chunk request will be allowed. Use 0 to disable this optimization.").defineInRange("friendlyChunkSpawnRate", 9, 0, 256);
            builder.pop();
            builder.push("View Area");
            this.viewAreaEnabled = builder.comment("Enable/Disable player based view area optimization.").define("viewAreaEnabled", true);
            builder.pop();
            builder.push("Global Spawn Limitations");
            this.spawnLimitationEnabled = builder.comment("Enable/Disable general spawn limitations.").define("spawnLimitationEnabled", true);
            this.spawnEggBypassLimitations = builder.comment("Enable/Disable bypassing spawn limitations when using spawn eggs. When enabled, spawn eggs will bypass player-based spawn limitations.").define("spawnEggBypassLimitations", true);
            this.spawnLimitationLimiter = builder.comment("Blocks every x spawn to avoid an over population with the limited spawn area. Use 0 to disable this optimization.").defineInRange("spawnLimitationLimiter", 16, 0, 100);
            this.spawnLimitationMaxMobsPerPlayer = builder.comment("Defines the max. number of entities of a specific type, which could spawn within the player view area. Use 0 to disable this optimization.").defineInRange("spawnLimitationMaxMobsPerPlayer", 32, 0, 256);
            this.spawnLimitationMaxMobsPerWorld = builder.comment("Defines the max. number of entities of a specific type, which could spawn within a single world. Use 0 to disable this optimization.").defineInRange("spawnLimitationMaxMobsPerWorld", 128, 0, 1024);
            this.spawnLimitationMaxMobsPerServer = builder.comment("Defines the max. number of entities of a specific type, which could spawn within the server. Use 0 to disable this optimization.").defineInRange("spawnLimitationMaxMobsPerServer", 512, 0, 1024);
            builder.pop();
        }
    }
}

