/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.Predicate;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraft.Util;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class CachedFloatingLongValue
extends CachedResolvableConfigValue<FloatingLong, String>
implements FloatingLongSupplier {
    private static final Predicate<Object> VALIDATOR = object -> CachedFloatingLongValue.tryGetValue(object) != null;
    public static final Predicate<Object> POSITIVE = object -> {
        FloatingLong value = CachedFloatingLongValue.tryGetValue(object);
        return value != null && value.greaterThan(FloatingLong.ZERO);
    };
    public static final Predicate<Object> ENERGY_CONVERSION = (Predicate)Util.m_137537_(() -> {
        FloatingLong max = FloatingLong.ONE.divide(FloatingLong.createConst(0L, (short)1)).copyAsConst();
        return CachedFloatingLongValue.greaterZeroLessThan(max);
    });

    public static Predicate<Object> greaterZeroLessThan(FloatingLong max) {
        return object -> {
            FloatingLong value = CachedFloatingLongValue.tryGetValue(object);
            return value != null && value.greaterThan(FloatingLong.ZERO) && value.smallerOrEqual(max);
        };
    }

    @Nullable
    private static FloatingLong tryGetValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return FloatingLong.parseFloatingLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private CachedFloatingLongValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<String> internal) {
        super(config, internal);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, false);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, boolean worldRestart) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, worldRestart, VALIDATOR);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, Predicate<Object> validator) {
        return CachedFloatingLongValue.define(config, builder, comment, path, defaultValue, false, validator);
    }

    public static CachedFloatingLongValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String comment, String path, FloatingLong defaultValue, boolean worldRestart, Predicate<Object> validator) {
        if (worldRestart) {
            builder.worldRestart();
        }
        return new CachedFloatingLongValue(config, (ForgeConfigSpec.ConfigValue<String>)builder.comment(comment).define(path, (Object)defaultValue.toString(), validator));
    }

    @Override
    protected FloatingLong resolve(String encoded) {
        return FloatingLong.parseFloatingLong(encoded, true);
    }

    @Override
    protected String encode(FloatingLong value) {
        return value.toString();
    }
}

