/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.base.Preconditions;
import net.mehvahdjukaar.moonlight.api.block.IBeeGrowable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlaxBlock
extends CropBlock
implements IBeeGrowable {
    public static final int DOUBLE_AGE = 4;
    private static final VoxelShape FULL_BOTTOM = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM};
    private static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, FULL_BOTTOM, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public FlaxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPES_BOTTOM[(Integer)state.m_61143_((Property)f_52244_)];
        }
        return SHAPES_TOP[(Integer)state.m_61143_((Property)f_52244_)];
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || this.isSingle(stateIn) || facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean isSingle(BlockState state) {
        return this.m_52305_(state) < 4;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (!state.m_60713_((Block)this)) {
            throw new IllegalArgumentException("Somebody (a mod) passed a [" + Utils.getID((Block)state.m_60734_()) + "] blockstate to a member function of [Flax] block. This breaks a contract");
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState above = worldIn.m_8055_(pos.m_7494_());
            if (above.m_60734_() == this && this.isSingle(above)) {
                return false;
            }
            return super.m_7898_(state, worldIn, pos);
        }
        if (this.isSingle(state)) {
            return false;
        }
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, worldIn, pos);
        }
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER && this.m_52305_(state) == this.m_52305_(blockstate);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            if (player.m_7500_()) {
                FlaxBlock.removeBottomHalf(worldIn, pos, state, player);
            } else {
                FlaxBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    protected static void removeBottomHalf(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    public void placeAt(LevelAccessor worldIn, BlockPos pos, int flags) {
        worldIn.m_7731_(pos, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        if (!PlatHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)1)) {
            return;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && this.m_7370_((LevelReader)level, pos, state, level.f_46443_) && ForgeHelper.onCropsGrowPre((ServerLevel)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = FlaxBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.growCropBy((Level)level, pos, state, 1);
            ForgeHelper.onCropsGrowPost((ServerLevel)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        Preconditions.checkArgument((boolean)state.m_60713_((Block)this), (Object)"Some mod passed a block that is not this own to the use method. This is bad!");
        InteractionResult old = super.m_6227_(state, world, pos, player, hand, rayTraceResult);
        if (!old.m_19077_() && !this.isSingle(state) && state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            InteractionResult ev = ForgeHelper.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)pos.m_7495_(), (BlockHitResult)rayTraceResult);
            if (ev != null) {
                return ev;
            }
            BlockState below = world.m_8055_(pos.m_7495_());
            if (below.m_60713_((Block)this)) {
                return this.m_6227_(below, world, pos.m_7495_(), player, hand, rayTraceResult);
            }
        }
        return old;
    }

    public boolean canGrowUp(BlockGetter worldIn, BlockPos downPos) {
        BlockState state = worldIn.m_8055_(downPos.m_7494_());
        return state.m_60734_() instanceof FlaxBlock || state.m_247087_();
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.m_52307_(state) && (this.canGrowUp((BlockGetter)worldIn, pos) || this.m_52305_(state) < 3);
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, this.m_7125_(level));
    }

    public void growCropBy(Level level, BlockPos pos, BlockState state, int increment) {
        if (increment > 1 && this.isSingle(state) && !this.canGrowUp((BlockGetter)level, pos)) {
            increment = 1;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
        }
        int newAge = this.m_52305_(state) + increment;
        if ((newAge = Math.min(newAge, this.m_7419_())) >= 4) {
            level.m_7731_(pos.m_7494_(), (BlockState)this.m_52289_(newAge).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        level.m_7731_(pos, this.m_52289_(newAge), 3);
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return false;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ModRegistry.FLAX_SEEDS_ITEM.get();
    }

    public boolean getPollinated(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, 1);
        return true;
    }
}

