/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    protected static CannonBlockTile cannon;
    private static CameraType lastCameraType;
    protected static HitResult hit;
    private static boolean firstTick;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    protected static ShootingMode shootingMode;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static Vec3 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;
    protected static boolean showsTrajectory;

    public static void startControlling(CannonBlockTile tile) {
        firstTick = true;
        Minecraft mc = Minecraft.m_91087_();
        if (cannon == null) {
            cannon = tile;
            shootingMode = cannon.getTrajectoryData().drag() != 0.0f ? ShootingMode.DOWN : ShootingMode.STRAIGHT;
            lastCameraType = mc.f_91066_.m_92176_();
        }
        mc.f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
        mc.f_91065_.m_93063_((Component)Component.m_237110_((String)"message.supplementaries.cannon_maneuver", (Object[])new Object[]{mc.f_91066_.f_92090_.m_90863_(), mc.f_91066_.f_92096_.m_90863_()}), false);
    }

    private static void stopControllingAndSync() {
        if (cannon == null) {
            return;
        }
        CannonBlockTile.syncToServer(cannon, false, true);
        CannonController.stopControlling();
    }

    public static void stopControlling() {
        if (cannon == null) {
            return;
        }
        cannon = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            Minecraft.m_91087_().f_91066_.m_92157_(lastCameraType);
        }
    }

    public static boolean isActive() {
        return cannon != null;
    }

    public static boolean setupCamera(Camera camera, BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (CannonController.isActive()) {
            Vec3 centerCannonPos = cannon.m_58899_().m_252807_();
            if (lastCameraPos == null) {
                lastCameraPos = camera.m_90583_();
                lastCameraYaw = camera.m_90590_();
                lastCameraPitch = camera.m_90589_();
            }
            Vec3 targetCameraPos = centerCannonPos.m_82520_(0.0, 2.0, 0.0);
            float targetYRot = camera.m_90590_() + yawIncrease;
            float targetXRot = Mth.m_14036_((float)(camera.m_90589_() + pitchIncrease), (float)-90.0f, (float)90.0f);
            camera.m_90581_(targetCameraPos);
            camera.m_90572_(targetYRot, targetXRot);
            lastCameraPos = camera.m_90583_();
            lastCameraYaw = camera.m_90590_();
            lastCameraPitch = camera.m_90589_();
            lastZoomOut = (float)camera.m_90566_(4.0);
            float horizontalOffset = -1.0f;
            camera.m_90568_((double)(-lastZoomOut), 0.0, (double)horizontalOffset);
            yawIncrease = 0.0f;
            pitchIncrease = 0.0f;
            if (!cannon.isFiring()) {
                Vec3 lookDir2 = new Vec3(camera.m_253058_());
                float maxRange = 128.0f;
                Vec3 actualCameraPos = camera.m_90583_().m_82549_(lookDir2.m_82541_());
                Vec3 endPos = actualCameraPos.m_82549_(lookDir2.m_82490_((double)maxRange));
                hit = level.m_45547_(new ClipContext(actualCameraPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, entity));
                Vec3 targetVector = hit.m_82450_().m_82546_(cannon.m_58899_().m_252807_());
                Vec2 target = new Vec2((float)Mth.m_184645_((double)targetVector.f_82479_, (double)targetVector.f_82481_), (float)targetVector.f_82480_);
                target = target.m_165910_(target.m_165902_().m_165903_(0.05f));
                float wantedCannonYaw = (float)Math.PI + (float)Mth.m_14136_((double)(-targetVector.f_82479_), (double)targetVector.f_82481_);
                CannonBlockTile.Restraint restraints = cannon.getPitchAndYawRestrains();
                IBallisticBehavior.Data ballistic = cannon.getTrajectoryData();
                trajectory = CannonTrajectory.findBest(target, ballistic.gravity(), ballistic.drag(), cannon.getFirePower() * ballistic.initialSpeed(), shootingMode, restraints.minPitch(), restraints.maxPitch());
                if (trajectory != null) {
                    CannonController.setCannonAngles(partialTick, wantedCannonYaw * 57.295776f);
                }
            }
            return true;
        }
        return false;
    }

    private static void setCannonAngles(float partialTick, float targetYawDeg) {
        float followSpeed = 1.0f;
        cannon.setRestrainedPitch(Mth.m_14189_((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
        cannon.setRenderYaw(targetYawDeg);
    }

    public static float ud(float a) {
        return a;
    }

    public static void onPlayerRotated(double yawAdd, double pitchAdd) {
        float scale = 0.2f;
        yawIncrease += (float)(yawAdd * (double)scale);
        pitchIncrease += (float)(pitchAdd * (double)scale);
        if (yawAdd != 0.0 || pitchAdd != 0.0) {
            needsToUpdateServer = true;
        }
    }

    public static void onKeyJump() {
        if (trajectory != null && trajectory.gravity() != 0.0f) {
            shootingMode = shootingMode.cycle();
            needsToUpdateServer = true;
        }
    }

    public static void onKeyInventory() {
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundRequestOpenCannonGuiMessage(cannon.m_58899_()));
    }

    public static void onKeyShift() {
        CannonController.stopControllingAndSync();
    }

    public static void onMouseScrolled(double scrollDelta) {
        if (scrollDelta != 0.0) {
            cannon.changeFirePower((int)scrollDelta);
            needsToUpdateServer = true;
        }
    }

    public static void onPlayerAttack() {
        if (cannon != null && cannon.readyToFire()) {
            CannonBlockTile.syncToServer(cannon, true, false);
        }
    }

    public static void onPlayerUse() {
        showsTrajectory = !showsTrajectory;
    }

    public static void onInputUpdate(Input input) {
        if (firstTick) {
            firstTick = false;
            input.f_108569_ = false;
            input.f_108572_ = false;
            input.f_108568_ = false;
            input.f_108570_ = false;
            input.f_108571_ = false;
            input.f_108573_ = false;
            input.f_108567_ = 0.0f;
            input.f_108566_ = 0.0f;
        }
    }

    public static void onClientTick(Minecraft mc) {
        if (!CannonController.isActive()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.m_9236_();
        BlockPos pos = cannon.m_58899_();
        float maxDist = 7.0f;
        if (level.m_7702_(pos) == cannon && !cannon.m_58901_() && pos.m_203193_((Position)player.m_20182_()) < (double)(maxDist * maxDist)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                CannonBlockTile.syncToServer(cannon, false, false);
            }
        } else {
            CannonController.stopControllingAndSync();
        }
    }

    static {
        firstTick = true;
        shootingMode = ShootingMode.DOWN;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        showsTrajectory = true;
    }
}

