/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.etherium.core;

import com.aizistral.enigmaticlegacy.config.EtheriumConfigHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.etherium.core.IEtheriumConfig;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IEtheriumTool {
    default public IEtheriumConfig getConfig() {
        return EtheriumConfigHandler.instance();
    }

    default public boolean areaEffectsEnabled(Player player, ItemStack stack) {
        return this.areaEffectsAllowed(stack) && (!player.m_6047_() || this.getConfig().disableAOEShiftInhibition());
    }

    default public boolean areaEffectsAllowed(ItemStack stack) {
        if (stack.m_41720_() instanceof IEtheriumTool) {
            return ItemNBTHelper.getBoolean(stack, "MultiblockEffectsEnabled", true);
        }
        return false;
    }

    default public void enableAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IEtheriumTool) {
            ItemNBTHelper.setBoolean(stack, "MultiblockEffectsEnabled", true);
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(null, player.m_20183_(), this.getConfig().getAOESoundOn(), SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        }
    }

    default public void disableAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IEtheriumTool) {
            ItemNBTHelper.setBoolean(stack, "MultiblockEffectsEnabled", false);
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(null, player.m_20183_(), this.getConfig().getAOESoundOff(), SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        }
    }

    default public void toggleAreaEffects(Player player, ItemStack stack) {
        if (stack.m_41720_() instanceof IEtheriumTool) {
            if (this.areaEffectsAllowed(stack)) {
                this.disableAreaEffects(player, stack);
            } else {
                this.enableAreaEffects(player, stack);
            }
        }
    }
}

