/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.event;

import com.eccarrascon.structurecredits.StructureCreditsClient;
import com.eccarrascon.structurecredits.client.StructureOverlayRenderer;
import com.eccarrascon.structurecredits.registry.KeyMapRegistry;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DisplayNameClient
implements ClientTickEvent.Client {
    private static String lastStructure = "haley:you_found_it!";
    private static String currentStructure = null;
    private static String previousStructure = null;

    public void tick(Minecraft instance) {
        KeyMapRegistry keyMapRegistry = KeyMapRegistry.getInstance();
        while (keyMapRegistry.getToggleActiveKeyMapping().m_90859_()) {
            this.toggleActiveState();
        }
        while (keyMapRegistry.getToggleOnlyOneTimeKeyMapping().m_90859_()) {
            this.toggleOnlyOneTime();
        }
        while (keyMapRegistry.getToggleChatMessageKeyMapping().m_90859_()) {
            this.toggleChatMessage();
        }
        while (keyMapRegistry.getToggleShowCreatorKeyMapping().m_90859_()) {
            this.toggleShowCreator();
        }
        while (keyMapRegistry.getToggleContinuousDisplayKeyMapping().m_90859_()) {
            this.toggleContinuousDisplay();
        }
        while (keyMapRegistry.getToggleRequireDifferentStructureKeyMapping().m_90859_()) {
            this.toggleRequireDifferentStructure();
        }
        while (keyMapRegistry.getShowAgainMsgKeyMapping().m_90859_()) {
            this.showLastStructureMessage();
        }
        while (keyMapRegistry.getDontShowMsgKeyMapping().m_90859_()) {
            this.addCurrentStructureToDontShow();
        }
        if (!StructureCreditsClient.CONFIG_VALUES.isChatMessage()) {
            StructureOverlayRenderer.tick();
        }
    }

    public static void updateStructureName(String structureName, boolean isPacket) {
        if (isPacket) {
            if (structureName == null || structureName.isEmpty()) {
                previousStructure = currentStructure;
                currentStructure = null;
                if (!StructureCreditsClient.CONFIG_VALUES.isChatMessage()) {
                    StructureOverlayRenderer.clearMessage();
                }
                return;
            }
            if (Objects.equals(currentStructure, structureName)) {
                return;
            }
            if (StructureCreditsClient.CONFIG_VALUES.isRequireDifferentStructure() && !StructureCreditsClient.CONFIG_VALUES.isOnlyOneTime() && Objects.equals(previousStructure, structureName)) {
                currentStructure = structureName;
                return;
            }
            previousStructure = currentStructure;
            currentStructure = structureName;
        }
        if (StructureCreditsClient.CONFIG_VALUES.isActive() || !isPacket) {
            lastStructure = structureName;
            DisplayNameClient.displayStructureMessage(structureName, isPacket);
        }
    }

    private static void displayStructureMessage(String structureName, boolean isPacket) {
        block6: {
            boolean showCreator;
            String structureNameFormatted;
            String modName;
            block7: {
                String customName = StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().getOrDefault(structureName, structureName);
                String[] parts = customName.split(":");
                if (parts.length != 2) break block6;
                modName = DisplayNameClient.formatName(parts[0]);
                structureNameFormatted = DisplayNameClient.formatName(parts[1]);
                showCreator = StructureCreditsClient.CONFIG_VALUES.isShowCreator();
                if (!isPacket) break block7;
                if (!StructureCreditsClient.CONFIG_VALUES.getDontShowAll().stream().noneMatch(structureName::startsWith) || StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) break block6;
            }
            if (StructureCreditsClient.CONFIG_VALUES.isChatMessage()) {
                String messageKey = showCreator ? "text.structurecredits.message" : "text.structurecredits.message_no_creator";
                MutableComponent messageComponent = Component.m_237110_((String)messageKey, (Object[])new Object[]{structureNameFormatted, modName});
                Minecraft.m_91087_().f_91074_.m_5661_((Component)messageComponent, false);
            } else {
                StructureOverlayRenderer.setMessage(structureNameFormatted, modName, showCreator);
            }
            if (isPacket && StructureCreditsClient.CONFIG_VALUES.isOnlyOneTime() && !StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(structureName);
                StructureCreditsClient.CONFIG.save();
            }
        }
    }

    private static String formatName(String name) {
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    private void toggleActiveState() {
        boolean isActive = !StructureCreditsClient.CONFIG_VALUES.isActive();
        StructureCreditsClient.CONFIG_VALUES.setActive(isActive);
        StructureCreditsClient.CONFIG.save();
        String messageKey = isActive ? "text.structurecredits.activated" : "text.structurecredits.deactivated";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void toggleOnlyOneTime() {
        boolean value = !StructureCreditsClient.CONFIG_VALUES.isOnlyOneTime();
        StructureCreditsClient.CONFIG_VALUES.setShowOnlyOneTime(value);
        StructureCreditsClient.CONFIG.save();
        String messageKey = value ? "text.structurecredits.only_one_time_enabled" : "text.structurecredits.only_one_time_disabled";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void toggleChatMessage() {
        boolean value = !StructureCreditsClient.CONFIG_VALUES.isChatMessage();
        StructureCreditsClient.CONFIG_VALUES.setChatMessage(value);
        StructureCreditsClient.CONFIG.save();
        String messageKey = value ? "text.structurecredits.chat_message_enabled" : "text.structurecredits.chat_message_disabled";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void toggleShowCreator() {
        boolean value = !StructureCreditsClient.CONFIG_VALUES.isShowCreator();
        StructureCreditsClient.CONFIG_VALUES.setShowCreator(value);
        StructureCreditsClient.CONFIG.save();
        String messageKey = value ? "text.structurecredits.show_creator_enabled" : "text.structurecredits.show_creator_disabled";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void toggleContinuousDisplay() {
        boolean value = !StructureCreditsClient.CONFIG_VALUES.isContinuousDisplay();
        StructureCreditsClient.CONFIG_VALUES.setContinuousDisplay(value);
        StructureCreditsClient.CONFIG.save();
        String messageKey = value ? "text.structurecredits.continuous_display_enabled" : "text.structurecredits.continuous_display_disabled";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void toggleRequireDifferentStructure() {
        boolean value = !StructureCreditsClient.CONFIG_VALUES.isRequireDifferentStructure();
        StructureCreditsClient.CONFIG_VALUES.setRequireDifferentStructure(value);
        StructureCreditsClient.CONFIG.save();
        String messageKey = value ? "text.structurecredits.require_different_enabled" : "text.structurecredits.require_different_disabled";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void showLastStructureMessage() {
        if (lastStructure != null) {
            DisplayNameClient.updateStructureName(lastStructure, false);
        }
    }

    private void addCurrentStructureToDontShow() {
        if (lastStructure != null) {
            if (!StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(lastStructure)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(lastStructure);
                StructureCreditsClient.CONFIG.save();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.dont_show"), true);
            } else {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.already_dont_show"), true);
            }
        }
    }
}

