/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.client;

import com.eccarrascon.structurecredits.StructureCreditsClient;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class StructureOverlayRenderer {
    private static String structureName = null;
    private static String modName = null;
    private static boolean showCreator = true;
    private static int displayTimer = 0;
    private static int fadeTimer = 0;
    private static final int FADE_DURATION = 10;
    private static final float WORDS_PER_SECOND = 4.0f;
    private static final int MIN_DISPLAY_TICKS = 40;

    public static void setMessage(String structure, String mod, boolean withCreator) {
        structureName = structure;
        modName = mod;
        showCreator = withCreator;
        if (!StructureCreditsClient.CONFIG_VALUES.isContinuousDisplay()) {
            displayTimer = StructureCreditsClient.CONFIG_VALUES.isAutoCalculateDuration() ? StructureOverlayRenderer.calculateReadingDuration(structure, mod, withCreator) : StructureCreditsClient.CONFIG_VALUES.getDisplayDuration();
            fadeTimer = 0;
        } else {
            displayTimer = Integer.MAX_VALUE;
            fadeTimer = 10;
        }
    }

    private static int calculateReadingDuration(String structure, String mod, boolean withCreator) {
        int wordCount = StructureOverlayRenderer.countWords(structure);
        wordCount = withCreator ? (wordCount += StructureOverlayRenderer.countWords(mod) + 4) : (wordCount += 2);
        int calculatedTicks = (int)((float)wordCount / 4.0f * 20.0f);
        return Math.max(40, calculatedTicks);
    }

    private static int countWords(String text) {
        if (text == null || text.trim().isEmpty()) {
            return 0;
        }
        return text.trim().split("\\s+").length;
    }

    public static void clearMessage() {
        structureName = null;
        modName = null;
        displayTimer = 0;
        fadeTimer = 0;
    }

    public static void tick() {
        if (structureName == null) {
            return;
        }
        if (StructureCreditsClient.CONFIG_VALUES.isContinuousDisplay()) {
            fadeTimer = 10;
            displayTimer = Integer.MAX_VALUE;
            return;
        }
        if (displayTimer > 0) {
            --displayTimer;
            if (fadeTimer < 10) {
                ++fadeTimer;
            }
        }
        if (displayTimer == 0 && fadeTimer > 0 && --fadeTimer == 0) {
            StructureOverlayRenderer.clearMessage();
        }
    }

    public static void render(GuiGraphics guiGraphics, float partialTicks) {
        if (structureName == null || fadeTimer <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float scale = StructureCreditsClient.CONFIG_VALUES.getTextSize();
        poseStack.m_85841_(scale, scale, 1.0f);
        String label1 = Component.m_237115_((String)"text.structurecredits.overlay.welcome").getString();
        String label2 = showCreator ? Component.m_237115_((String)"text.structurecredits.overlay.by").getString() : "";
        int label1Width = mc.f_91062_.m_92895_(label1);
        int structureWidth = mc.f_91062_.m_92895_(structureName);
        int label2Width = mc.f_91062_.m_92895_(label2);
        int modWidth = showCreator ? mc.f_91062_.m_92895_(modName) : 0;
        int totalWidth = label1Width + structureWidth + label2Width + modWidth;
        Objects.requireNonNull(mc.f_91062_);
        int messageHeight = 9;
        int screenWidth = (int)((float)mc.m_91268_().m_85445_() / scale);
        int screenHeight = (int)((float)mc.m_91268_().m_85446_() / scale);
        int x = StructureOverlayRenderer.calculateX(screenWidth, totalWidth);
        int y = StructureOverlayRenderer.calculateY(screenHeight, messageHeight);
        float alpha = StructureOverlayRenderer.calculateAlpha();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int labelColor = StructureCreditsClient.CONFIG_VALUES.getLabelColor();
        int nameColor = StructureCreditsClient.CONFIG_VALUES.getNameColor();
        int labelColorWithAlpha = StructureOverlayRenderer.applyAlpha(labelColor, alpha);
        int nameColorWithAlpha = StructureOverlayRenderer.applyAlpha(nameColor, alpha);
        guiGraphics.m_280056_(mc.f_91062_, label1, x, y, labelColorWithAlpha, true);
        guiGraphics.m_280056_(mc.f_91062_, structureName, x += label1Width, y, nameColorWithAlpha, true);
        x += structureWidth;
        if (showCreator) {
            guiGraphics.m_280056_(mc.f_91062_, label2, x, y, labelColorWithAlpha, true);
            guiGraphics.m_280056_(mc.f_91062_, modName, x += label2Width, y, nameColorWithAlpha, true);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static int applyAlpha(int color, float alpha) {
        int alphaValue = (int)(alpha * 255.0f);
        return color & 0xFFFFFF | alphaValue << 24;
    }

    private static int calculateX(int screenWidth, int messageWidth) {
        String position = StructureCreditsClient.CONFIG_VALUES.getDisplayPosition();
        int offset = StructureCreditsClient.CONFIG_VALUES.getDisplayOffsetX();
        return switch (position) {
            case "TOP_LEFT", "BOTTOM_LEFT" -> offset;
            case "TOP_CENTER", "CENTER", "BOTTOM_CENTER" -> (screenWidth - messageWidth) / 2;
            case "TOP_RIGHT", "BOTTOM_RIGHT" -> screenWidth - messageWidth - offset;
            default -> offset;
        };
    }

    private static int calculateY(int screenHeight, int messageHeight) {
        String position = StructureCreditsClient.CONFIG_VALUES.getDisplayPosition();
        int offset = StructureCreditsClient.CONFIG_VALUES.getDisplayOffsetY();
        return switch (position) {
            case "TOP_LEFT", "TOP_CENTER", "TOP_RIGHT" -> offset;
            case "CENTER" -> (screenHeight - messageHeight) / 2;
            case "BOTTOM_LEFT", "BOTTOM_CENTER", "BOTTOM_RIGHT" -> screenHeight - messageHeight - offset;
            default -> offset;
        };
    }

    private static float calculateAlpha() {
        if (StructureCreditsClient.CONFIG_VALUES.isContinuousDisplay()) {
            return 1.0f;
        }
        if (displayTimer > 10) {
            return Math.min(1.0f, (float)fadeTimer / 10.0f);
        }
        if (displayTimer > 0 && fadeTimer >= 10) {
            return 1.0f;
        }
        if (displayTimer == 0) {
            return Math.max(0.0f, (float)fadeTimer / 10.0f);
        }
        return 1.0f;
    }

    public static boolean isDisplaying() {
        return structureName != null && fadeTimer > 0;
    }
}

