/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits;

import com.ecarrascon.carrasconlib.config.LibConfig;
import com.eccarrascon.structurecredits.ConfigData;
import com.eccarrascon.structurecredits.StructureCredits;
import com.eccarrascon.structurecredits.api.StructureCreditsAPI;
import com.eccarrascon.structurecredits.client.StructureOverlayRenderer;
import com.eccarrascon.structurecredits.event.DisplayNameClient;
import com.eccarrascon.structurecredits.network.StructureCreditsNet;
import com.eccarrascon.structurecredits.registry.KeyMapRegistry;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureCreditsClient {
    public static LibConfig<ConfigData> CONFIG;
    public static ConfigData CONFIG_VALUES;

    public static void onInitializeClient() {
        CONFIG = new LibConfig("structurecredits-config.json", ConfigData.class, StructureCredits.LOGGER);
        CONFIG_VALUES = (ConfigData)CONFIG.get();
        StructureCreditsAPI.flushPendingMappings();
        StructureCreditsNet.initializeClient();
        KeyMapRegistry keyMapRegistry = KeyMapRegistry.getInstance();
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleActiveKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleOnlyOneTimeKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleChatMessageKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleShowCreatorKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleContinuousDisplayKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getToggleRequireDifferentStructureKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getShowAgainMsgKeyMapping());
        KeyMappingRegistry.register((KeyMapping)keyMapRegistry.getDontShowMsgKeyMapping());
        ClientTickEvent.CLIENT_POST.register((Object)new DisplayNameClient());
        ClientGuiEvent.RENDER_HUD.register((guiGraphics, partialTick) -> {
            if (!CONFIG_VALUES.isChatMessage()) {
                StructureOverlayRenderer.render(guiGraphics, partialTick);
            }
        });
    }
}

